/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Properties that can be expected to receive inside a form or formResponse message field. ")
@JsonPropertyOrder(value={"type", "name", "label", "placeholder", "minSize", "maxSize", "text", "email", "select", "options"})
public class Field {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_PLACEHOLDER = "placeholder";
    private String placeholder;
    public static final String JSON_PROPERTY_MIN_SIZE = "minSize";
    private Integer minSize = 1;
    public static final String JSON_PROPERTY_MAX_SIZE = "maxSize";
    private Integer maxSize = 128;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_SELECT = "select";
    private List<Object> select = null;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private List<Object> options = null;

    public Field type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The field type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Field name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the field. Must be unique per form or formResponse.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Field label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(required=true, value="The label of the field. What the field is displayed as on Web Messenger.")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Field placeholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Placeholder text for the field. Form message only.")
    @JsonProperty(value="placeholder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public Field minSize(Integer minSize) {
        this.minSize = minSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum allowed length for the response for a field of type text. Form message only.")
    @JsonProperty(value="minSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    public Field maxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum allowed length for the response for a field of type text. Form message only.")
    @JsonProperty(value="maxSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public Field text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the response for a text field.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Field email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the response for a email field.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Field select(List<Object> select) {
        this.select = select;
        return this;
    }

    public Field addSelectItem(Object selectItem) {
        if (this.select == null) {
            this.select = new ArrayList<Object>();
        }
        this.select.add(selectItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of objects representing the response for a field of type select. Form and formResponse messages only.")
    @JsonProperty(value="select")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getSelect() {
        return this.select;
    }

    public void setSelect(List<Object> select) {
        this.select = select;
    }

    public Field options(List<Object> options) {
        this.options = options;
        return this;
    }

    public Field addOptionsItem(Object optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<Object>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of objects representing options for a field of type select.")
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getOptions() {
        return this.options;
    }

    public void setOptions(List<Object> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return Objects.equals((Object)this.type, (Object)field.type) && Objects.equals(this.name, field.name) && Objects.equals(this.label, field.label) && Objects.equals(this.placeholder, field.placeholder) && Objects.equals(this.minSize, field.minSize) && Objects.equals(this.maxSize, field.maxSize) && Objects.equals(this.text, field.text) && Objects.equals(this.email, field.email) && Objects.equals(this.select, field.select) && Objects.equals(this.options, field.options);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.label, this.placeholder, this.minSize, this.maxSize, this.text, this.email, this.select, this.options});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Field {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    placeholder: ").append(this.toIndentedString(this.placeholder)).append("\n");
        sb.append("    minSize: ").append(this.toIndentedString(this.minSize)).append("\n");
        sb.append("    maxSize: ").append(this.toIndentedString(this.maxSize)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    select: ").append(this.toIndentedString(this.select)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        EMAIL("email"),
        SELECT("select"),
        TEXT("text");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

