/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "pageAccessToken", "appId", "appSecret", "businessName", "businessUsername", "pageId", "businessId", "username", "userId"})
public class InstagramAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "instagram";
    public static final String JSON_PROPERTY_PAGE_ACCESS_TOKEN = "pageAccessToken";
    private String pageAccessToken;
    public static final String JSON_PROPERTY_APP_ID = "appId";
    private String appId;
    public static final String JSON_PROPERTY_APP_SECRET = "appSecret";
    private String appSecret;
    public static final String JSON_PROPERTY_BUSINESS_NAME = "businessName";
    private String businessName;
    public static final String JSON_PROPERTY_BUSINESS_USERNAME = "businessUsername";
    private String businessUsername;
    public static final String JSON_PROPERTY_PAGE_ID = "pageId";
    private String pageId;
    public static final String JSON_PROPERTY_BUSINESS_ID = "businessId";
    private String businessId;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public InstagramAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Instagram Direct setup steps:   - Take note of your Facebook app ID and secret (apps can be created at [developer.facebook.com](https://developer.facebook.com));   - The Facebook app must have been submitted to Meta for app review with the \"pages_manage_metadata\" (to retrieve Page Access Tokens for the Pages and apps that the app user administers and to set a webhook), \"instagram_basic\", and \"instagram_manage_messages\" (to retrieve basic Instagram account information and send messages) permissions.   - In order to integrate an Instagram Direct app, you must acquire a Page Access Token from your user. Once you have acquired a page access token from your user, call the Create Integration endpoint with your app secret and ID and the user\u2019s page access token. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public InstagramAllOf pageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
        return this;
    }

    @ApiModelProperty(example="your_page_access_token", required=true, value="The Facebook Page Access Token of the Facebook page that is linked to your Instagram account.")
    @JsonProperty(value="pageAccessToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPageAccessToken() {
        return this.pageAccessToken;
    }

    public void setPageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
    }

    public InstagramAllOf appId(String appId) {
        this.appId = appId;
        return this;
    }

    @ApiModelProperty(example="your_facebook_app_id", required=true, value="Your Facebook App ID.")
    @JsonProperty(value="appId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public InstagramAllOf appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    @ApiModelProperty(example="your_facebook_app_secret", required=true, value="Your Facebook App secret.")
    @JsonProperty(value="appSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Nullable
    @ApiModelProperty(example="instagram_name", value="Your Instagram Business account name")
    @JsonProperty(value="businessName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessName() {
        return this.businessName;
    }

    @Nullable
    @ApiModelProperty(example="instagram_username", value="Your Instagram Business unique username")
    @JsonProperty(value="businessUsername")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessUsername() {
        return this.businessUsername;
    }

    @Nullable
    @ApiModelProperty(example="106731941223392", value="The ID of the Facebook Page linked to your Instagram Business account")
    @JsonProperty(value="pageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageId() {
        return this.pageId;
    }

    @Nullable
    @ApiModelProperty(example="17841444303043201", value="The ID of the Instagram Business account")
    @JsonProperty(value="businessId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessId() {
        return this.businessId;
    }

    @Nullable
    @ApiModelProperty(example="facebook_username", value="The Facebook user's username. This is returned when integrating through the Dashboard")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @Nullable
    @ApiModelProperty(example="100885965124932", value="The Facebook user's user ID. This is returned when integrating through the Dashboard")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstagramAllOf instagramAllOf = (InstagramAllOf)o;
        return Objects.equals(this.type, instagramAllOf.type) && Objects.equals(this.pageAccessToken, instagramAllOf.pageAccessToken) && Objects.equals(this.appId, instagramAllOf.appId) && Objects.equals(this.appSecret, instagramAllOf.appSecret) && Objects.equals(this.businessName, instagramAllOf.businessName) && Objects.equals(this.businessUsername, instagramAllOf.businessUsername) && Objects.equals(this.pageId, instagramAllOf.pageId) && Objects.equals(this.businessId, instagramAllOf.businessId) && Objects.equals(this.username, instagramAllOf.username) && Objects.equals(this.userId, instagramAllOf.userId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pageAccessToken, this.appId, this.appSecret, this.businessName, this.businessUsername, this.pageId, this.businessId, this.username, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstagramAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    pageAccessToken: ").append(this.toIndentedString(this.pageAccessToken)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    appSecret: ").append(this.toIndentedString(this.appSecret)).append("\n");
        sb.append("    businessName: ").append(this.toIndentedString(this.businessName)).append("\n");
        sb.append("    businessUsername: ").append(this.toIndentedString(this.businessUsername)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("    businessId: ").append(this.toIndentedString(this.businessId)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

