/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.ActionSubset;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"title", "description", "mediaUrl", "mediaType", "altText", "size", "actions", "metadata"})
public class Item {
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_MEDIA_URL = "mediaUrl";
    private URI mediaUrl;
    public static final String JSON_PROPERTY_MEDIA_TYPE = "mediaType";
    private String mediaType;
    public static final String JSON_PROPERTY_ALT_TEXT = "altText";
    private String altText;
    public static final String JSON_PROPERTY_SIZE = "size";
    private SizeEnum size;
    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private List<ActionSubset> actions = new ArrayList<ActionSubset>();
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Object> metadata = JsonNullable.undefined();

    public Item title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(required=true, value="The title of the item.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Item description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The description of the item.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Item mediaUrl(URI mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The image url attached to the item.")
    @JsonProperty(value="mediaUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getMediaUrl() {
        return this.mediaUrl;
    }

    public void setMediaUrl(URI mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    public Item mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The MIME type for any image attached in the mediaUrl.")
    @JsonProperty(value="mediaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public Item altText(String altText) {
        this.altText = altText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional description of the media for accessibility purposes. The field will be saved by default with the file name as the value.")
    @JsonProperty(value="altText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public Item size(SizeEnum size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The size of the image.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SizeEnum getSize() {
        return this.size;
    }

    public void setSize(SizeEnum size) {
        this.size = size;
    }

    public Item actions(List<ActionSubset> actions) {
        this.actions = actions;
        return this;
    }

    public Item addActionsItem(ActionSubset actionsItem) {
        this.actions.add(actionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of objects representing the actions associated with the item.")
    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ActionSubset> getActions() {
        return this.actions;
    }

    public void setActions(List<ActionSubset> actions) {
        this.actions = actions;
    }

    public Item metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Object getMetadata() {
        return this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.title, item.title) && Objects.equals(this.description, item.description) && Objects.equals(this.mediaUrl, item.mediaUrl) && Objects.equals(this.mediaType, item.mediaType) && Objects.equals(this.altText, item.altText) && Objects.equals((Object)this.size, (Object)item.size) && Objects.equals(this.actions, item.actions) && Objects.equals(this.metadata, item.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.description, this.mediaUrl, this.mediaType, this.altText, this.size, this.actions, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    mediaUrl: ").append(this.toIndentedString(this.mediaUrl)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    altText: ").append(this.toIndentedString(this.altText)).append("\n");
        sb.append("    size: ").append(this.toIndentedString((Object)this.size)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SizeEnum {
        COMPACT("compact"),
        LARGE("large");

        private String value;

        private SizeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SizeEnum fromValue(String value) {
            for (SizeEnum b : SizeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

