/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information about the location.")
@JsonPropertyOrder(value={"address", "name"})
public class LocationMessageLocation {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public LocationMessageLocation address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A string representing the address of the location.")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public LocationMessageLocation name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A string representing the name of the location.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationMessageLocation locationMessageLocation = (LocationMessageLocation)o;
        return Objects.equals(this.address, locationMessageLocation.address) && Objects.equals(this.name, locationMessageLocation.name);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocationMessageLocation {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

