/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Action;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A location request action will prompt the user to share their location.")
@JsonPropertyOrder(value={"type", "text", "metadata"})
public class LocationRequest
implements Action {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "locationRequest";
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Object> metadata = JsonNullable.undefined();

    public LocationRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of action.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LocationRequest text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(required=true, value="The button text.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public LocationRequest metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Object getMetadata() {
        return this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)o;
        return Objects.equals(this.type, locationRequest.type) && Objects.equals(this.text, locationRequest.text) && Objects.equals(this.metadata, locationRequest.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.text, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocationRequest {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

