/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "pageAccessToken", "appId", "appSecret", "pageId", "pageName"})
public class MessengerAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "messenger";
    public static final String JSON_PROPERTY_PAGE_ACCESS_TOKEN = "pageAccessToken";
    private String pageAccessToken;
    public static final String JSON_PROPERTY_APP_ID = "appId";
    private String appId;
    public static final String JSON_PROPERTY_APP_SECRET = "appSecret";
    private String appSecret;
    public static final String JSON_PROPERTY_PAGE_ID = "pageId";
    private BigDecimal pageId;
    public static final String JSON_PROPERTY_PAGE_NAME = "pageName";
    private String pageName;

    public MessengerAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Facebook Messenger Setup steps: - Take note of your Facebook app ID and secret (apps can be created at developer.facebook.com); - The Facebook app must have been submitted to Meta for app review with the \u201cpages_manage_metadata\u201d (to retrieve Page Access Tokens for the Pages, apps that the app user administers and set a webhook) and \u201cpages_messaging\u201d (to send messages) permissions. - In order to integrate a Facebook Messenger app you must acquire a Page Access Token from your user. Once you have acquired a page access token from your user, call the Create Integration endpoint with your app secret and ID and the user\u2019s page access token. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MessengerAllOf pageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
        return this;
    }

    @ApiModelProperty(example="your_access_token", required=true, value="A Facebook Page Access Token.")
    @JsonProperty(value="pageAccessToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPageAccessToken() {
        return this.pageAccessToken;
    }

    public void setPageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
    }

    public MessengerAllOf appId(String appId) {
        this.appId = appId;
        return this;
    }

    @ApiModelProperty(example="your_facebook_app_id", required=true, value="A Facebook App ID.")
    @JsonProperty(value="appId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public MessengerAllOf appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    @ApiModelProperty(example="your_facebook_app_secret", required=true, value="A Facebook App Secret.")
    @JsonProperty(value="appSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public MessengerAllOf pageId(BigDecimal pageId) {
        this.pageId = pageId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123212323432123", value="A Facebook page ID.")
    @JsonProperty(value="pageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getPageId() {
        return this.pageId;
    }

    public void setPageId(BigDecimal pageId) {
        this.pageId = pageId;
    }

    public MessengerAllOf pageName(String pageName) {
        this.pageName = pageName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="An Awesome Page", value="A Facebook page name.")
    @JsonProperty(value="pageName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessengerAllOf messengerAllOf = (MessengerAllOf)o;
        return Objects.equals(this.type, messengerAllOf.type) && Objects.equals(this.pageAccessToken, messengerAllOf.pageAccessToken) && Objects.equals(this.appId, messengerAllOf.appId) && Objects.equals(this.appSecret, messengerAllOf.appSecret) && Objects.equals(this.pageId, messengerAllOf.pageId) && Objects.equals(this.pageName, messengerAllOf.pageName);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pageAccessToken, this.appId, this.appSecret, this.pageId, this.pageName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessengerAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    pageAccessToken: ").append(this.toIndentedString(this.pageAccessToken)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    appSecret: ").append(this.toIndentedString(this.appSecret)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("    pageName: ").append(this.toIndentedString(this.pageName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

