/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ClientAssociation;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "userId", "unreadCount", "clientAssociations", "userExternalId", "lastRead"})
public class Participant {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_UNREAD_COUNT = "unreadCount";
    private Integer unreadCount;
    public static final String JSON_PROPERTY_CLIENT_ASSOCIATIONS = "clientAssociations";
    private List<ClientAssociation> clientAssociations = null;
    public static final String JSON_PROPERTY_USER_EXTERNAL_ID = "userExternalId";
    private JsonNullable<String> userExternalId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LAST_READ = "lastRead";
    private JsonNullable<String> lastRead = JsonNullable.undefined();

    public Participant id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="c93bb9c14dde8ffb94564eae", value="The unique ID of the participant.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Participant userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="42589ad070d43be9b00ff7e5", value="The id of the associated user.")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Participant unreadCount(Integer unreadCount) {
        this.unreadCount = unreadCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="Number of messages the user has not yet read.")
    @JsonProperty(value="unreadCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getUnreadCount() {
        return this.unreadCount;
    }

    public void setUnreadCount(Integer unreadCount) {
        this.unreadCount = unreadCount;
    }

    public Participant clientAssociations(List<ClientAssociation> clientAssociations) {
        this.clientAssociations = clientAssociations;
        return this;
    }

    public Participant addClientAssociationsItem(ClientAssociation clientAssociationsItem) {
        if (this.clientAssociations == null) {
            this.clientAssociations = new ArrayList<ClientAssociation>();
        }
        this.clientAssociations.add(clientAssociationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the clients that are active in the conversation for a particular user. A participant can have multiple clientAssociations in the case of channel transfer, business initiated conversations, or identified users. The order of the array indicates how recently a client has interacted with the conversation, with the most recent client first. The first item in the array is considered to be the user's primary client for that conversation, and will be selected first for message delivery. ")
    @JsonProperty(value="clientAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ClientAssociation> getClientAssociations() {
        return this.clientAssociations;
    }

    public void setClientAssociations(List<ClientAssociation> clientAssociations) {
        this.clientAssociations = clientAssociations;
    }

    public Participant userExternalId(String userExternalId) {
        this.userExternalId = JsonNullable.of((Object)userExternalId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-own-id", value="The externalId of the associated user.")
    @JsonIgnore
    public String getUserExternalId() {
        return (String)this.userExternalId.orElse(null);
    }

    @JsonProperty(value="userExternalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getUserExternalId_JsonNullable() {
        return this.userExternalId;
    }

    @JsonProperty(value="userExternalId")
    public void setUserExternalId_JsonNullable(JsonNullable<String> userExternalId) {
        this.userExternalId = userExternalId;
    }

    public void setUserExternalId(String userExternalId) {
        this.userExternalId = JsonNullable.of((Object)userExternalId);
    }

    public Participant lastRead(String lastRead) {
        this.lastRead = JsonNullable.of((Object)lastRead);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-01-14T18:55:12.515Z", value="A datetime string with the format YYYY-MM-DDThh:mm:ss.SSSZ representing the latest message the user has read.")
    @JsonIgnore
    public String getLastRead() {
        return (String)this.lastRead.orElse(null);
    }

    @JsonProperty(value="lastRead")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLastRead_JsonNullable() {
        return this.lastRead;
    }

    @JsonProperty(value="lastRead")
    public void setLastRead_JsonNullable(JsonNullable<String> lastRead) {
        this.lastRead = lastRead;
    }

    public void setLastRead(String lastRead) {
        this.lastRead = JsonNullable.of((Object)lastRead);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant participant = (Participant)o;
        return Objects.equals(this.id, participant.id) && Objects.equals(this.userId, participant.userId) && Objects.equals(this.unreadCount, participant.unreadCount) && Objects.equals(this.clientAssociations, participant.clientAssociations) && Objects.equals(this.userExternalId, participant.userExternalId) && Objects.equals(this.lastRead, participant.lastRead);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userId, this.unreadCount, this.clientAssociations, this.userExternalId, this.lastRead);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Participant {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    unreadCount: ").append(this.toIndentedString(this.unreadCount)).append("\n");
        sb.append("    clientAssociations: ").append(this.toIndentedString(this.clientAssociations)).append("\n");
        sb.append("    userExternalId: ").append(this.toIndentedString(this.userExternalId)).append("\n");
        sb.append("    lastRead: ").append(this.toIndentedString(this.lastRead)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

