/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Object hosting user profile information.")
@JsonPropertyOrder(value={"givenName", "surname", "email", "avatarUrl", "locale"})
public class Profile {
    public static final String JSON_PROPERTY_GIVEN_NAME = "givenName";
    private JsonNullable<String> givenName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SURNAME = "surname";
    private JsonNullable<String> surname = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EMAIL = "email";
    private JsonNullable<String> email = JsonNullable.undefined();
    public static final String JSON_PROPERTY_AVATAR_URL = "avatarUrl";
    private JsonNullable<URI> avatarUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LOCALE = "locale";
    private JsonNullable<String> locale = JsonNullable.undefined();

    public Profile givenName(String givenName) {
        this.givenName = JsonNullable.of((Object)givenName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Jane", value="The user's given name (first name).")
    @JsonIgnore
    public String getGivenName() {
        return (String)this.givenName.orElse(null);
    }

    @JsonProperty(value="givenName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getGivenName_JsonNullable() {
        return this.givenName;
    }

    @JsonProperty(value="givenName")
    public void setGivenName_JsonNullable(JsonNullable<String> givenName) {
        this.givenName = givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = JsonNullable.of((Object)givenName);
    }

    public Profile surname(String surname) {
        this.surname = JsonNullable.of((Object)surname);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Doe", value="The user's surname (last name).")
    @JsonIgnore
    public String getSurname() {
        return (String)this.surname.orElse(null);
    }

    @JsonProperty(value="surname")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSurname_JsonNullable() {
        return this.surname;
    }

    @JsonProperty(value="surname")
    public void setSurname_JsonNullable(JsonNullable<String> surname) {
        this.surname = surname;
    }

    public void setSurname(String surname) {
        this.surname = JsonNullable.of((Object)surname);
    }

    public Profile email(String email) {
        this.email = JsonNullable.of((Object)email);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="jane.doe@gmail.com", value="The user's email address.")
    @JsonIgnore
    public String getEmail() {
        return (String)this.email.orElse(null);
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getEmail_JsonNullable() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail_JsonNullable(JsonNullable<String> email) {
        this.email = email;
    }

    public void setEmail(String email) {
        this.email = JsonNullable.of((Object)email);
    }

    public Profile avatarUrl(URI avatarUrl) {
        this.avatarUrl = JsonNullable.of((Object)avatarUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://s3.amazonaws.com/avatar.jpg", value="The user's avatar.")
    @JsonIgnore
    public URI getAvatarUrl() {
        return (URI)this.avatarUrl.orElse(null);
    }

    @JsonProperty(value="avatarUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getAvatarUrl_JsonNullable() {
        return this.avatarUrl;
    }

    @JsonProperty(value="avatarUrl")
    public void setAvatarUrl_JsonNullable(JsonNullable<URI> avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public void setAvatarUrl(URI avatarUrl) {
        this.avatarUrl = JsonNullable.of((Object)avatarUrl);
    }

    public Profile locale(String locale) {
        this.locale = JsonNullable.of((Object)locale);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="fr-CA", value="End-user's locale information in BCP 47 format.")
    @JsonIgnore
    public String getLocale() {
        return (String)this.locale.orElse(null);
    }

    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLocale_JsonNullable() {
        return this.locale;
    }

    @JsonProperty(value="locale")
    public void setLocale_JsonNullable(JsonNullable<String> locale) {
        this.locale = locale;
    }

    public void setLocale(String locale) {
        this.locale = JsonNullable.of((Object)locale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profile profile = (Profile)o;
        return Objects.equals(this.givenName, profile.givenName) && Objects.equals(this.surname, profile.surname) && Objects.equals(this.email, profile.email) && Objects.equals(this.avatarUrl, profile.avatarUrl) && Objects.equals(this.locale, profile.locale);
    }

    public int hashCode() {
        return Objects.hash(this.givenName, this.surname, this.email, this.avatarUrl, this.locale);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Profile {\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    surname: ").append(this.toIndentedString(this.surname)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    avatarUrl: ").append(this.toIndentedString(this.avatarUrl)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

