/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "name", "integrationId", "integrationType", "deliverStandbyEvents", "nextSwitchboardIntegrationId", "messageHistoryCount"})
public class SwitchboardIntegration {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private String integrationId;
    public static final String JSON_PROPERTY_INTEGRATION_TYPE = "integrationType";
    private String integrationType;
    public static final String JSON_PROPERTY_DELIVER_STANDBY_EVENTS = "deliverStandbyEvents";
    private Boolean deliverStandbyEvents;
    public static final String JSON_PROPERTY_NEXT_SWITCHBOARD_INTEGRATION_ID = "nextSwitchboardIntegrationId";
    private String nextSwitchboardIntegrationId;
    public static final String JSON_PROPERTY_MESSAGE_HISTORY_COUNT = "messageHistoryCount";
    private JsonNullable<Integer> messageHistoryCount = JsonNullable.undefined();

    public SwitchboardIntegration id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="5ef21b86e933b7355c11c604", required=true, value="The unique ID of the switchboard integration.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SwitchboardIntegration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="bot", required=true, value="Identifier for use in control transfer protocols. Restricted to alphanumeric characters, `-` and `_`.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SwitchboardIntegration integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="5ef21b86e933b7355c11c605", required=true, value="Id of the integration that should deliver events routed by the switchboard.")
    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public SwitchboardIntegration integrationType(String integrationType) {
        this.integrationType = integrationType;
        return this;
    }

    @ApiModelProperty(example="zd:agentWorkspace", required=true, value="Type of integration that should deliver events routed by the switchboard. If referencing an OAuth integration, the clientId issued by Sunshine Conversations during the OAuth partnership process will be the value of integrationType.")
    @JsonProperty(value="integrationType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(String integrationType) {
        this.integrationType = integrationType;
    }

    public SwitchboardIntegration deliverStandbyEvents(Boolean deliverStandbyEvents) {
        this.deliverStandbyEvents = deliverStandbyEvents;
        return this;
    }

    @ApiModelProperty(required=true, value="Setting to determine if webhooks should be sent when the switchboard integration is not in control of a conversation (standby status)")
    @JsonProperty(value="deliverStandbyEvents")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getDeliverStandbyEvents() {
        return this.deliverStandbyEvents;
    }

    public void setDeliverStandbyEvents(Boolean deliverStandbyEvents) {
        this.deliverStandbyEvents = deliverStandbyEvents;
    }

    public SwitchboardIntegration nextSwitchboardIntegrationId(String nextSwitchboardIntegrationId) {
        this.nextSwitchboardIntegrationId = nextSwitchboardIntegrationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5ef21b86e933b7355c11c606", value="The switchboard integration id to which control of a conversation is passed / offered by default.")
    @JsonProperty(value="nextSwitchboardIntegrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNextSwitchboardIntegrationId() {
        return this.nextSwitchboardIntegrationId;
    }

    public void setNextSwitchboardIntegrationId(String nextSwitchboardIntegrationId) {
        this.nextSwitchboardIntegrationId = nextSwitchboardIntegrationId;
    }

    public SwitchboardIntegration messageHistoryCount(Integer messageHistoryCount) {
        this.messageHistoryCount = JsonNullable.of((Object)messageHistoryCount);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="Number of messages to include in the message history context.")
    @JsonIgnore
    public Integer getMessageHistoryCount() {
        return (Integer)this.messageHistoryCount.orElse(null);
    }

    @JsonProperty(value="messageHistoryCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMessageHistoryCount_JsonNullable() {
        return this.messageHistoryCount;
    }

    @JsonProperty(value="messageHistoryCount")
    public void setMessageHistoryCount_JsonNullable(JsonNullable<Integer> messageHistoryCount) {
        this.messageHistoryCount = messageHistoryCount;
    }

    public void setMessageHistoryCount(Integer messageHistoryCount) {
        this.messageHistoryCount = JsonNullable.of((Object)messageHistoryCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchboardIntegration switchboardIntegration = (SwitchboardIntegration)o;
        return Objects.equals(this.id, switchboardIntegration.id) && Objects.equals(this.name, switchboardIntegration.name) && Objects.equals(this.integrationId, switchboardIntegration.integrationId) && Objects.equals(this.integrationType, switchboardIntegration.integrationType) && Objects.equals(this.deliverStandbyEvents, switchboardIntegration.deliverStandbyEvents) && Objects.equals(this.nextSwitchboardIntegrationId, switchboardIntegration.nextSwitchboardIntegrationId) && Objects.equals(this.messageHistoryCount, switchboardIntegration.messageHistoryCount);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.integrationId, this.integrationType, this.deliverStandbyEvents, this.nextSwitchboardIntegrationId, this.messageHistoryCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SwitchboardIntegration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    integrationType: ").append(this.toIndentedString(this.integrationType)).append("\n");
        sb.append("    deliverStandbyEvents: ").append(this.toIndentedString(this.deliverStandbyEvents)).append("\n");
        sb.append("    nextSwitchboardIntegrationId: ").append(this.toIndentedString(this.nextSwitchboardIntegrationId)).append("\n");
        sb.append("    messageHistoryCount: ").append(this.toIndentedString(this.messageHistoryCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

