/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "accountSid", "authToken", "phoneNumberSid", "messagingServiceSid"})
public class TwilioAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "twilio";
    public static final String JSON_PROPERTY_ACCOUNT_SID = "accountSid";
    private String accountSid;
    public static final String JSON_PROPERTY_AUTH_TOKEN = "authToken";
    private String authToken;
    public static final String JSON_PROPERTY_PHONE_NUMBER_SID = "phoneNumberSid";
    private String phoneNumberSid;
    public static final String JSON_PROPERTY_MESSAGING_SERVICE_SID = "messagingServiceSid";
    private String messagingServiceSid;

    public TwilioAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="To configure a Twilio integration, acquire the required information from the user and call the Create Integration endpoint. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TwilioAllOf accountSid(String accountSid) {
        this.accountSid = accountSid;
        return this;
    }

    @ApiModelProperty(example="ACa1b4c65ee0722712fab89867cb14eac7", required=true, value="Twilio Account SID.")
    @JsonProperty(value="accountSid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountSid() {
        return this.accountSid;
    }

    public void setAccountSid(String accountSid) {
        this.accountSid = accountSid;
    }

    public TwilioAllOf authToken(String authToken) {
        this.authToken = authToken;
        return this;
    }

    @ApiModelProperty(example="160c024303f53049e1e060fd67ca6aefc", required=true, value="Twilio Auth Token.")
    @JsonProperty(value="authToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public TwilioAllOf phoneNumberSid(String phoneNumberSid) {
        this.phoneNumberSid = phoneNumberSid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PN0674df0ecee0c9819bca0ff0bc0a159e", value="SID for specific phone number. One of `messagingServiceSid` or `phoneNumberSid` must be provided when creating a Twilio integration.")
    @JsonProperty(value="phoneNumberSid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumberSid() {
        return this.phoneNumberSid;
    }

    public void setPhoneNumberSid(String phoneNumberSid) {
        this.phoneNumberSid = phoneNumberSid;
    }

    public TwilioAllOf messagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SID for specific messaging service. One of `messagingServiceSid` or `phoneNumberSid` must be provided when creating a Twilio integration.")
    @JsonProperty(value="messagingServiceSid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public void setMessagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwilioAllOf twilioAllOf = (TwilioAllOf)o;
        return Objects.equals(this.type, twilioAllOf.type) && Objects.equals(this.accountSid, twilioAllOf.accountSid) && Objects.equals(this.authToken, twilioAllOf.authToken) && Objects.equals(this.phoneNumberSid, twilioAllOf.phoneNumberSid) && Objects.equals(this.messagingServiceSid, twilioAllOf.messagingServiceSid);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.accountSid, this.authToken, this.phoneNumberSid, this.messagingServiceSid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TwilioAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    accountSid: ").append(this.toIndentedString(this.accountSid)).append("\n");
        sb.append("    authToken: ").append(this.toIndentedString(this.authToken)).append("\n");
        sb.append("    phoneNumberSid: ").append(this.toIndentedString(this.phoneNumberSid)).append("\n");
        sb.append("    messagingServiceSid: ").append(this.toIndentedString(this.messagingServiceSid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

