/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.Android;
import com.zendesk.sunshine_conversations_client.model.Apple;
import com.zendesk.sunshine_conversations_client.model.Custom;
import com.zendesk.sunshine_conversations_client.model.Instagram;
import com.zendesk.sunshine_conversations_client.model.Integration;
import com.zendesk.sunshine_conversations_client.model.Ios;
import com.zendesk.sunshine_conversations_client.model.Line;
import com.zendesk.sunshine_conversations_client.model.Mailgun;
import com.zendesk.sunshine_conversations_client.model.Messagebird;
import com.zendesk.sunshine_conversations_client.model.Messenger;
import com.zendesk.sunshine_conversations_client.model.Telegram;
import com.zendesk.sunshine_conversations_client.model.Twilio;
import com.zendesk.sunshine_conversations_client.model.Viber;
import com.zendesk.sunshine_conversations_client.model.Web;
import com.zendesk.sunshine_conversations_client.model.Whatsapp;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "tier", "envName", "consumerKey", "consumerSecret", "accessTokenKey", "accessTokenSecret"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Android.class, name="android"), @JsonSubTypes.Type(value=Apple.class, name="apple"), @JsonSubTypes.Type(value=Custom.class, name="custom"), @JsonSubTypes.Type(value=Instagram.class, name="instagram"), @JsonSubTypes.Type(value=Ios.class, name="ios"), @JsonSubTypes.Type(value=Line.class, name="line"), @JsonSubTypes.Type(value=Mailgun.class, name="mailgun"), @JsonSubTypes.Type(value=Messagebird.class, name="messagebird"), @JsonSubTypes.Type(value=Messenger.class, name="messenger"), @JsonSubTypes.Type(value=Telegram.class, name="telegram"), @JsonSubTypes.Type(value=Twilio.class, name="twilio"), @JsonSubTypes.Type(value=Twitter.class, name="twitter"), @JsonSubTypes.Type(value=Viber.class, name="viber"), @JsonSubTypes.Type(value=Web.class, name="web"), @JsonSubTypes.Type(value=Whatsapp.class, name="whatsapp")})
public class Twitter
extends Integration {
    public static final String JSON_PROPERTY_TYPE = "type";
    protected String type = "twitter";
    public static final String JSON_PROPERTY_TIER = "tier";
    private TierEnum tier;
    public static final String JSON_PROPERTY_ENV_NAME = "envName";
    private String envName;
    public static final String JSON_PROPERTY_CONSUMER_KEY = "consumerKey";
    private String consumerKey;
    public static final String JSON_PROPERTY_CONSUMER_SECRET = "consumerSecret";
    private String consumerSecret;
    public static final String JSON_PROPERTY_ACCESS_TOKEN_KEY = "accessTokenKey";
    private String accessTokenKey;
    public static final String JSON_PROPERTY_ACCESS_TOKEN_SECRET = "accessTokenSecret";
    private String accessTokenSecret;

    @Override
    public Twitter type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="To set up a Twitter integration, please follow the steps outlined in the [Twitter Setup Guide](https://docs.smooch.io/guide/twitter/#setup). ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Twitter tier(TierEnum tier) {
        this.tier = tier;
        return this;
    }

    @ApiModelProperty(required=true, value="Your Twitter app\u2019s tier, sandbox, premium or enterprise.")
    @JsonProperty(value="tier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TierEnum getTier() {
        return this.tier;
    }

    public void setTier(TierEnum tier) {
        this.tier = tier;
    }

    public Twitter envName(String envName) {
        this.envName = envName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_env_label", value="The Twitter dev environments label (required for sandbox and premium tiers).")
    @JsonProperty(value="envName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public Twitter consumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    @ApiModelProperty(example="your_consumer_key", required=true, value="The consumer key for your Twitter app.")
    @JsonProperty(value="consumerKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public Twitter consumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    @ApiModelProperty(example="your_consumer_secret", required=true, value="The consumer key secret for your Twitter app.")
    @JsonProperty(value="consumerSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public Twitter accessTokenKey(String accessTokenKey) {
        this.accessTokenKey = accessTokenKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_access_token_key", value="The access token key obtained from your user via oauth.")
    @JsonProperty(value="accessTokenKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public void setAccessTokenKey(String accessTokenKey) {
        this.accessTokenKey = accessTokenKey;
    }

    public Twitter accessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
        return this;
    }

    @ApiModelProperty(example="your_access_token_secret", required=true, value="The access token secret obtained from your user via oauth.")
    @JsonProperty(value="accessTokenSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Twitter twitter = (Twitter)o;
        return Objects.equals(this.type, twitter.type) && Objects.equals((Object)this.tier, (Object)twitter.tier) && Objects.equals(this.envName, twitter.envName) && Objects.equals(this.consumerKey, twitter.consumerKey) && Objects.equals(this.consumerSecret, twitter.consumerSecret) && Objects.equals(this.accessTokenKey, twitter.accessTokenKey) && Objects.equals(this.accessTokenSecret, twitter.accessTokenSecret) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.tier, this.envName, this.consumerKey, this.consumerSecret, this.accessTokenKey, this.accessTokenSecret, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Twitter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    tier: ").append(this.toIndentedString((Object)this.tier)).append("\n");
        sb.append("    envName: ").append(this.toIndentedString(this.envName)).append("\n");
        sb.append("    consumerKey: ").append(this.toIndentedString(this.consumerKey)).append("\n");
        sb.append("    consumerSecret: ").append(this.toIndentedString(this.consumerSecret)).append("\n");
        sb.append("    accessTokenKey: ").append(this.toIndentedString(this.accessTokenKey)).append("\n");
        sb.append("    accessTokenSecret: ").append(this.toIndentedString(this.accessTokenSecret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TierEnum {
        SANDBOX("sandbox"),
        PREMIUM("premium"),
        ENTERPRISE("enterprise");

        private String value;

        private TierEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TierEnum fromValue(String value) {
            for (TierEnum b : TierEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

