/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains information about the users that were merged together.")
@JsonPropertyOrder(value={"surviving", "discarded"})
public class UserMergeEventAllOfPayloadMergedUsers {
    public static final String JSON_PROPERTY_SURVIVING = "surviving";
    private User surviving = null;
    public static final String JSON_PROPERTY_DISCARDED = "discarded";
    private User discarded = null;

    public UserMergeEventAllOfPayloadMergedUsers surviving(User surviving) {
        this.surviving = surviving;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user that now represents the merged user object.")
    @JsonProperty(value="surviving")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public User getSurviving() {
        return this.surviving;
    }

    public void setSurviving(User surviving) {
        this.surviving = surviving;
    }

    public UserMergeEventAllOfPayloadMergedUsers discarded(User discarded) {
        this.discarded = discarded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user that was unified into the surviving user object.")
    @JsonProperty(value="discarded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public User getDiscarded() {
        return this.discarded;
    }

    public void setDiscarded(User discarded) {
        this.discarded = discarded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserMergeEventAllOfPayloadMergedUsers userMergeEventAllOfPayloadMergedUsers = (UserMergeEventAllOfPayloadMergedUsers)o;
        return Objects.equals(this.surviving, userMergeEventAllOfPayloadMergedUsers.surviving) && Objects.equals(this.discarded, userMergeEventAllOfPayloadMergedUsers.discarded);
    }

    public int hashCode() {
        return Objects.hash(this.surviving, this.discarded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserMergeEventAllOfPayloadMergedUsers {\n");
        sb.append("    surviving: ").append(this.toIndentedString(this.surviving)).append("\n");
        sb.append("    discarded: ").append(this.toIndentedString(this.discarded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

