/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"target", "triggers", "includeFullUser", "includeFullSource"})
public class WebhookBody {
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_TRIGGERS = "triggers";
    private List<String> triggers = null;
    public static final String JSON_PROPERTY_INCLUDE_FULL_USER = "includeFullUser";
    private Boolean includeFullUser = false;
    public static final String JSON_PROPERTY_INCLUDE_FULL_SOURCE = "includeFullSource";
    private Boolean includeFullSource = false;

    public WebhookBody target(String target) {
        this.target = target;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.com/callback", value="URL to be called when the webhook is triggered.")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public WebhookBody triggers(List<String> triggers) {
        this.triggers = triggers;
        return this;
    }

    public WebhookBody addTriggersItem(String triggersItem) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<String>();
        }
        this.triggers.add(triggersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"conversation:read\",\"conversation:message\"]", value="An array of triggers the integration is subscribed to. This property is case sensitive. [More details](https://docs.smooch.io/rest/#section/Webhook-Triggers).")
    @JsonProperty(value="triggers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<String> triggers) {
        this.triggers = triggers;
    }

    public WebhookBody includeFullUser(Boolean includeFullUser) {
        this.includeFullUser = includeFullUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean specifying whether webhook payloads should include the complete user schema for events involving a specific user.")
    @JsonProperty(value="includeFullUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeFullUser() {
        return this.includeFullUser;
    }

    public void setIncludeFullUser(Boolean includeFullUser) {
        this.includeFullUser = includeFullUser;
    }

    public WebhookBody includeFullSource(Boolean includeFullSource) {
        this.includeFullSource = includeFullSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean specifying whether webhook payloads should include the client and device object (when applicable).")
    @JsonProperty(value="includeFullSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeFullSource() {
        return this.includeFullSource;
    }

    public void setIncludeFullSource(Boolean includeFullSource) {
        this.includeFullSource = includeFullSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookBody webhookBody = (WebhookBody)o;
        return Objects.equals(this.target, webhookBody.target) && Objects.equals(this.triggers, webhookBody.triggers) && Objects.equals(this.includeFullUser, webhookBody.includeFullUser) && Objects.equals(this.includeFullSource, webhookBody.includeFullSource);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.triggers, this.includeFullUser, this.includeFullSource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookBody {\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    triggers: ").append(this.toIndentedString(this.triggers)).append("\n");
        sb.append("    includeFullUser: ").append(this.toIndentedString(this.includeFullUser)).append("\n");
        sb.append("    includeFullSource: ").append(this.toIndentedString(this.includeFullSource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

