/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The webhook that generated the payload.")
@JsonPropertyOrder(value={"id", "version"})
public class WebhookSubSchema {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;

    public WebhookSubSchema id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique ID of the webhook.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WebhookSubSchema version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Schema version of the payload delivered to this webhook (v2).")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookSubSchema webhookSubSchema = (WebhookSubSchema)o;
        return Objects.equals(this.id, webhookSubSchema.id) && Objects.equals(this.version, webhookSubSchema.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookSubSchema {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

