/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.Action;
import com.zendesk.sunshine_conversations_client.model.ActionSubset;
import com.zendesk.sunshine_conversations_client.model.ExtraChannelOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="When a webview actions is clicked/tapped, the provided URI will be loaded in a webview. Channels that do not support webviews will open the fallback URI instead.")
@JsonPropertyOrder(value={"type", "uri", "text", "default", "metadata", "extraChannelOptions", "size", "fallback", "openOnReceive"})
public class Webview
implements Action,
ActionSubset {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_URI = "uri";
    private URI uri;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_DEFAULT = "default";
    private Boolean _default;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Object> metadata = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXTRA_CHANNEL_OPTIONS = "extraChannelOptions";
    private ExtraChannelOptions extraChannelOptions;
    public static final String JSON_PROPERTY_SIZE = "size";
    private SizeEnum size;
    public static final String JSON_PROPERTY_FALLBACK = "fallback";
    private String fallback;
    public static final String JSON_PROPERTY_OPEN_ON_RECEIVE = "openOnReceive";
    private Boolean openOnReceive;

    public Webview type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of action.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Webview uri(URI uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(required=true, value="The webview URI. This is the URI that will open in the webview when clicking the button.")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public Webview text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(required=true, value="The button text.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Webview _default(Boolean _default) {
        this._default = _default;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value indicating whether the action is the default action for a message item in Facebook Messenger.")
    @JsonProperty(value="default")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDefault() {
        return this._default;
    }

    public void setDefault(Boolean _default) {
        this._default = _default;
    }

    public Webview metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Object getMetadata() {
        return this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
    }

    public Webview extraChannelOptions(ExtraChannelOptions extraChannelOptions) {
        this.extraChannelOptions = extraChannelOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="extraChannelOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExtraChannelOptions getExtraChannelOptions() {
        return this.extraChannelOptions;
    }

    public void setExtraChannelOptions(ExtraChannelOptions extraChannelOptions) {
        this.extraChannelOptions = extraChannelOptions;
    }

    public Webview size(SizeEnum size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The size to display a webview. Used for actions of type webview.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SizeEnum getSize() {
        return this.size;
    }

    public void setSize(SizeEnum size) {
        this.size = size;
    }

    public Webview fallback(String fallback) {
        this.fallback = fallback;
        return this;
    }

    @ApiModelProperty(required=true, value="The fallback uri for channels that don\u2019t support webviews. Used for actions of type webview.")
    @JsonProperty(value="fallback")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFallback() {
        return this.fallback;
    }

    public void setFallback(String fallback) {
        this.fallback = fallback;
    }

    public Webview openOnReceive(Boolean openOnReceive) {
        this.openOnReceive = openOnReceive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value indicating if the webview should open automatically. Only one action per message can be set to true. Currently only supported on the Web Messenger.")
    @JsonProperty(value="openOnReceive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOpenOnReceive() {
        return this.openOnReceive;
    }

    public void setOpenOnReceive(Boolean openOnReceive) {
        this.openOnReceive = openOnReceive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webview webview = (Webview)o;
        return Objects.equals(this.type, webview.type) && Objects.equals(this.uri, webview.uri) && Objects.equals(this.text, webview.text) && Objects.equals(this._default, webview._default) && Objects.equals(this.metadata, webview.metadata) && Objects.equals(this.extraChannelOptions, webview.extraChannelOptions) && Objects.equals((Object)this.size, (Object)webview.size) && Objects.equals(this.fallback, webview.fallback) && Objects.equals(this.openOnReceive, webview.openOnReceive);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.uri, this.text, this._default, this.metadata, this.extraChannelOptions, this.size, this.fallback, this.openOnReceive});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webview {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    extraChannelOptions: ").append(this.toIndentedString(this.extraChannelOptions)).append("\n");
        sb.append("    size: ").append(this.toIndentedString((Object)this.size)).append("\n");
        sb.append("    fallback: ").append(this.toIndentedString(this.fallback)).append("\n");
        sb.append("    openOnReceive: ").append(this.toIndentedString(this.openOnReceive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SizeEnum {
        COMPACT("compact"),
        TALL("tall"),
        FULL("full");

        private String value;

        private SizeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SizeEnum fromValue(String value) {
            for (SizeEnum b : SizeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

