/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.IntegrationUpdate;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"displayName", "hsmFallbackLanguage", "accountId", "accountManagementAccessToken"})
public class WhatsAppUpdate
implements IntegrationUpdate {
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private JsonNullable<String> displayName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_HSM_FALLBACK_LANGUAGE = "hsmFallbackLanguage";
    private JsonNullable<String> hsmFallbackLanguage = JsonNullable.of((Object)"en_US");
    public static final String JSON_PROPERTY_ACCOUNT_ID = "accountId";
    private JsonNullable<String> accountId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ACCOUNT_MANAGEMENT_ACCESS_TOKEN = "accountManagementAccessToken";
    private JsonNullable<String> accountManagementAccessToken = JsonNullable.undefined();

    public WhatsAppUpdate displayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My awesome integration", value="A human-friendly name used to identify the integration. `displayName` can be unset by changing it to `null`.")
    @JsonIgnore
    public String getDisplayName() {
        return (String)this.displayName.orElse(null);
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDisplayName_JsonNullable() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName_JsonNullable(JsonNullable<String> displayName) {
        this.displayName = displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
    }

    public WhatsAppUpdate hsmFallbackLanguage(String hsmFallbackLanguage) {
        this.hsmFallbackLanguage = JsonNullable.of((Object)hsmFallbackLanguage);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify a fallback language to use when sending WhatsApp message template using the short hand syntax. Defaults to en_US. See WhatsApp documentation for more info.")
    @JsonIgnore
    public String getHsmFallbackLanguage() {
        return (String)this.hsmFallbackLanguage.orElse(null);
    }

    @JsonProperty(value="hsmFallbackLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getHsmFallbackLanguage_JsonNullable() {
        return this.hsmFallbackLanguage;
    }

    @JsonProperty(value="hsmFallbackLanguage")
    public void setHsmFallbackLanguage_JsonNullable(JsonNullable<String> hsmFallbackLanguage) {
        this.hsmFallbackLanguage = hsmFallbackLanguage;
    }

    public void setHsmFallbackLanguage(String hsmFallbackLanguage) {
        this.hsmFallbackLanguage = JsonNullable.of((Object)hsmFallbackLanguage);
    }

    public WhatsAppUpdate accountId(String accountId) {
        this.accountId = JsonNullable.of((Object)accountId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_whatsApp_account_id", value="The business ID associated with the WhatsApp account. In combination with accountManagementAccessToken, it\u2019s used for Message Template Reconstruction.")
    @JsonIgnore
    public String getAccountId() {
        return (String)this.accountId.orElse(null);
    }

    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAccountId_JsonNullable() {
        return this.accountId;
    }

    @JsonProperty(value="accountId")
    public void setAccountId_JsonNullable(JsonNullable<String> accountId) {
        this.accountId = accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = JsonNullable.of((Object)accountId);
    }

    public WhatsAppUpdate accountManagementAccessToken(String accountManagementAccessToken) {
        this.accountManagementAccessToken = JsonNullable.of((Object)accountManagementAccessToken);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_access_token", value="An access token associated with the accountId used to query the WhatsApp Account Management API. In combination with accountId, it\u2019s used for Message Template Reconstruction.")
    @JsonIgnore
    public String getAccountManagementAccessToken() {
        return (String)this.accountManagementAccessToken.orElse(null);
    }

    @JsonProperty(value="accountManagementAccessToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAccountManagementAccessToken_JsonNullable() {
        return this.accountManagementAccessToken;
    }

    @JsonProperty(value="accountManagementAccessToken")
    public void setAccountManagementAccessToken_JsonNullable(JsonNullable<String> accountManagementAccessToken) {
        this.accountManagementAccessToken = accountManagementAccessToken;
    }

    public void setAccountManagementAccessToken(String accountManagementAccessToken) {
        this.accountManagementAccessToken = JsonNullable.of((Object)accountManagementAccessToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsAppUpdate whatsAppUpdate = (WhatsAppUpdate)o;
        return Objects.equals(this.displayName, whatsAppUpdate.displayName) && Objects.equals(this.hsmFallbackLanguage, whatsAppUpdate.hsmFallbackLanguage) && Objects.equals(this.accountId, whatsAppUpdate.accountId) && Objects.equals(this.accountManagementAccessToken, whatsAppUpdate.accountManagementAccessToken);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.hsmFallbackLanguage, this.accountId, this.accountManagementAccessToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsAppUpdate {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    hsmFallbackLanguage: ").append(this.toIndentedString(this.hsmFallbackLanguage)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountManagementAccessToken: ").append(this.toIndentedString(this.accountManagementAccessToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

