/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "deploymentId", "hsmFallbackLanguage", "accountId", "accountManagementAccessToken", "phoneNumber"})
public class WhatsappAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "whatsapp";
    public static final String JSON_PROPERTY_DEPLOYMENT_ID = "deploymentId";
    private String deploymentId;
    public static final String JSON_PROPERTY_HSM_FALLBACK_LANGUAGE = "hsmFallbackLanguage";
    private JsonNullable<String> hsmFallbackLanguage = JsonNullable.of((Object)"en_US");
    public static final String JSON_PROPERTY_ACCOUNT_ID = "accountId";
    private JsonNullable<String> accountId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ACCOUNT_MANAGEMENT_ACCESS_TOKEN = "accountManagementAccessToken";
    private JsonNullable<String> accountManagementAccessToken = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private JsonNullable<String> phoneNumber = JsonNullable.undefined();

    public WhatsappAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="To configure a WhatsApp integration, use your WhatsApp API Client connection information. Sunshine Conversations can provide WhatsApp API Client hosting for approved brands. See our [WhatsApp guide](https://docs.smooch.io/guide/whatsapp/#whatsapp-api-client) for more details on WhatsApp API Client hosting. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public WhatsappAllOf deploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    @ApiModelProperty(example="55c8d9758590aa1900b9b9aa", required=true, value="The Id of the deployment. The integrationId and the appId will be added to the deployment. Additionally, the deployment\u2019s status will be set to integrated.")
    @JsonProperty(value="deploymentId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public WhatsappAllOf hsmFallbackLanguage(String hsmFallbackLanguage) {
        this.hsmFallbackLanguage = JsonNullable.of((Object)hsmFallbackLanguage);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify a fallback language to use when sending WhatsApp message template using the short hand syntax. Defaults to en_US. See WhatsApp documentation for more info.")
    @JsonIgnore
    public String getHsmFallbackLanguage() {
        return (String)this.hsmFallbackLanguage.orElse(null);
    }

    @JsonProperty(value="hsmFallbackLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getHsmFallbackLanguage_JsonNullable() {
        return this.hsmFallbackLanguage;
    }

    @JsonProperty(value="hsmFallbackLanguage")
    public void setHsmFallbackLanguage_JsonNullable(JsonNullable<String> hsmFallbackLanguage) {
        this.hsmFallbackLanguage = hsmFallbackLanguage;
    }

    public void setHsmFallbackLanguage(String hsmFallbackLanguage) {
        this.hsmFallbackLanguage = JsonNullable.of((Object)hsmFallbackLanguage);
    }

    public WhatsappAllOf accountId(String accountId) {
        this.accountId = JsonNullable.of((Object)accountId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_whatsApp_account_id", value="The business ID associated with the WhatsApp account. In combination with accountManagementAccessToken, it\u2019s used for Message Template Reconstruction.")
    @JsonIgnore
    public String getAccountId() {
        return (String)this.accountId.orElse(null);
    }

    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAccountId_JsonNullable() {
        return this.accountId;
    }

    @JsonProperty(value="accountId")
    public void setAccountId_JsonNullable(JsonNullable<String> accountId) {
        this.accountId = accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = JsonNullable.of((Object)accountId);
    }

    public WhatsappAllOf accountManagementAccessToken(String accountManagementAccessToken) {
        this.accountManagementAccessToken = JsonNullable.of((Object)accountManagementAccessToken);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_access_token", value="An access token associated with the accountId used to query the WhatsApp Account Management API. In combination with accountId, it\u2019s used for Message Template Reconstruction.")
    @JsonIgnore
    public String getAccountManagementAccessToken() {
        return (String)this.accountManagementAccessToken.orElse(null);
    }

    @JsonProperty(value="accountManagementAccessToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAccountManagementAccessToken_JsonNullable() {
        return this.accountManagementAccessToken;
    }

    @JsonProperty(value="accountManagementAccessToken")
    public void setAccountManagementAccessToken_JsonNullable(JsonNullable<String> accountManagementAccessToken) {
        this.accountManagementAccessToken = accountManagementAccessToken;
    }

    public void setAccountManagementAccessToken(String accountManagementAccessToken) {
        this.accountManagementAccessToken = JsonNullable.of((Object)accountManagementAccessToken);
    }

    @Nullable
    @ApiModelProperty(example="15144441919", value="The phone number that is associated with the deployment of this integration, if one exists.")
    @JsonIgnore
    public String getPhoneNumber() {
        if (this.phoneNumber == null) {
            this.phoneNumber = JsonNullable.undefined();
        }
        return (String)this.phoneNumber.orElse(null);
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPhoneNumber_JsonNullable() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    private void setPhoneNumber_JsonNullable(JsonNullable<String> phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappAllOf whatsappAllOf = (WhatsappAllOf)o;
        return Objects.equals(this.type, whatsappAllOf.type) && Objects.equals(this.deploymentId, whatsappAllOf.deploymentId) && Objects.equals(this.hsmFallbackLanguage, whatsappAllOf.hsmFallbackLanguage) && Objects.equals(this.accountId, whatsappAllOf.accountId) && Objects.equals(this.accountManagementAccessToken, whatsappAllOf.accountManagementAccessToken) && Objects.equals(this.phoneNumber, whatsappAllOf.phoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.deploymentId, this.hsmFallbackLanguage, this.accountId, this.accountManagementAccessToken, this.phoneNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    deploymentId: ").append(this.toIndentedString(this.deploymentId)).append("\n");
        sb.append("    hsmFallbackLanguage: ").append(this.toIndentedString(this.hsmFallbackLanguage)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountManagementAccessToken: ").append(this.toIndentedString(this.accountManagementAccessToken)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

