/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ClientType {
    LINE("line"),
    MAILGUN("mailgun"),
    MESSAGEBIRD("messagebird"),
    MESSENGER("messenger"),
    SDK("sdk"),
    TELEGRAM("telegram"),
    TWILIO("twilio"),
    TWITTER("twitter"),
    VIBER("viber"),
    WECHAT("wechat"),
    WHATSAPP("whatsapp");

    private String value;

    private ClientType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static ClientType fromValue(String value) {
        for (ClientType b : ClientType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

