/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Activity;
import com.zendesk.sunshine_conversations_client.model.ConversationTruncated;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The payload of the event. The contents of this object depend on the type of event.")
@JsonPropertyOrder(value={"conversation", "activity"})
public class ConversationReadEventAllOfPayload {
    public static final String JSON_PROPERTY_CONVERSATION = "conversation";
    private ConversationTruncated conversation = null;
    public static final String JSON_PROPERTY_ACTIVITY = "activity";
    private Activity activity = null;

    public ConversationReadEventAllOfPayload conversation(ConversationTruncated conversation) {
        this.conversation = conversation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversation in which the message was read.")
    @JsonProperty(value="conversation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationTruncated getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationTruncated conversation) {
        this.conversation = conversation;
    }

    public ConversationReadEventAllOfPayload activity(Activity activity) {
        this.activity = activity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The activity that was sent.")
    @JsonProperty(value="activity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Activity getActivity() {
        return this.activity;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationReadEventAllOfPayload conversationReadEventAllOfPayload = (ConversationReadEventAllOfPayload)o;
        return Objects.equals(this.conversation, conversationReadEventAllOfPayload.conversation) && Objects.equals(this.activity, conversationReadEventAllOfPayload.activity);
    }

    public int hashCode() {
        return Objects.hash(this.conversation, this.activity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationReadEventAllOfPayload {\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    activity: ").append(this.toIndentedString(this.activity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

