/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The set of criteria used to determine the user's identity on a third-party channel.")
@JsonPropertyOrder(value={"type", "integrationId", "primary"})
public class MatchCriteriaBase {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private String integrationId;
    public static final String JSON_PROPERTY_PRIMARY = "primary";
    private Boolean primary = true;

    public MatchCriteriaBase type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The channel type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MatchCriteriaBase integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="582dedf230e788746891281a", required=true, value="The ID of the integration to link. Must match the provided type.")
    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public MatchCriteriaBase primary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Flag indicating whether the client will become the primary for the target conversation once linking is complete.")
    @JsonProperty(value="primary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchCriteriaBase matchCriteriaBase = (MatchCriteriaBase)o;
        return Objects.equals(this.type, matchCriteriaBase.type) && Objects.equals(this.integrationId, matchCriteriaBase.integrationId) && Objects.equals(this.primary, matchCriteriaBase.primary);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.integrationId, this.primary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchCriteriaBase {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

