/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Field;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"avatarUrl", "enabled", "enableEmailLinking", "fields"})
public class PrechatCapture {
    public static final String JSON_PROPERTY_AVATAR_URL = "avatarUrl";
    private String avatarUrl = "undefined";
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = false;
    public static final String JSON_PROPERTY_ENABLE_EMAIL_LINKING = "enableEmailLinking";
    private Boolean enableEmailLinking = false;
    public static final String JSON_PROPERTY_FIELDS = "fields";
    private List<Field> fields = null;

    public PrechatCapture avatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://domain.com/images/avatar.png", value="Sets the URL of the avatar to use for the automatic reply to the prechat capture messages.")
    @JsonProperty(value="avatarUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public PrechatCapture enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, enables the Prechat Capture add-on when the Web Messenger is initialized.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public PrechatCapture enableEmailLinking(Boolean enableEmailLinking) {
        this.enableEmailLinking = enableEmailLinking;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="f true and Mailgun is integrated, will automatically link submitted emails.")
    @JsonProperty(value="enableEmailLinking")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnableEmailLinking() {
        return this.enableEmailLinking;
    }

    public void setEnableEmailLinking(Boolean enableEmailLinking) {
        this.enableEmailLinking = enableEmailLinking;
    }

    public PrechatCapture fields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    public PrechatCapture addFieldsItem(Field fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"type\":\"email\",\"name\":\"email\",\"label\":\"Email\",\"placeholder\":\"your@email.com\"},{\"type\":\"text\",\"name\":\"company-website\",\"label\":\"Company website\",\"placeholder\":\"mycompany.com\"}]", value="Array of Fields. Overrides the default Prechat Capture fields to define a custom form.")
    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrechatCapture prechatCapture = (PrechatCapture)o;
        return Objects.equals(this.avatarUrl, prechatCapture.avatarUrl) && Objects.equals(this.enabled, prechatCapture.enabled) && Objects.equals(this.enableEmailLinking, prechatCapture.enableEmailLinking) && Objects.equals(this.fields, prechatCapture.fields);
    }

    public int hashCode() {
        return Objects.hash(this.avatarUrl, this.enabled, this.enableEmailLinking, this.fields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrechatCapture {\n");
        sb.append("    avatarUrl: ").append(this.toIndentedString(this.avatarUrl)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    enableEmailLinking: ").append(this.toIndentedString(this.enableEmailLinking)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

