/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response metadata.")
@JsonPropertyOrder(value={"hasMore", "afterCursor", "beforeCursor"})
public class Meta {
    public static final String JSON_PROPERTY_HAS_MORE = "hasMore";
    private Boolean hasMore;
    public static final String JSON_PROPERTY_AFTER_CURSOR = "afterCursor";
    private String afterCursor;
    public static final String JSON_PROPERTY_BEFORE_CURSOR = "beforeCursor";
    private String beforeCursor;

    public Meta hasMore(Boolean hasMore) {
        this.hasMore = hasMore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag that indicates if there are more records that can be fetched.")
    @JsonProperty(value="hasMore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasMore() {
        return this.hasMore;
    }

    public void setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
    }

    public Meta afterCursor(String afterCursor) {
        this.afterCursor = afterCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="55c8d9758590aa1900b9b9f6", value="A record id that can be used as a `page[after]` parameter in a new request to get the next page.  Not specified if there are no subsequent pages. ")
    @JsonProperty(value="afterCursor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAfterCursor() {
        return this.afterCursor;
    }

    public void setAfterCursor(String afterCursor) {
        this.afterCursor = afterCursor;
    }

    public Meta beforeCursor(String beforeCursor) {
        this.beforeCursor = beforeCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="55c8d9758590aa1900b9b9f6", value="A record id that can be used as a `page[before]` parameter in a new request to get the previous page.  Not specified if there are no previous pages. ")
    @JsonProperty(value="beforeCursor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBeforeCursor() {
        return this.beforeCursor;
    }

    public void setBeforeCursor(String beforeCursor) {
        this.beforeCursor = beforeCursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Meta meta = (Meta)o;
        return Objects.equals(this.hasMore, meta.hasMore) && Objects.equals(this.afterCursor, meta.afterCursor) && Objects.equals(this.beforeCursor, meta.beforeCursor);
    }

    public int hashCode() {
        return Objects.hash(this.hasMore, this.afterCursor, this.beforeCursor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Meta {\n");
        sb.append("    hasMore: ").append(this.toIndentedString(this.hasMore)).append("\n");
        sb.append("    afterCursor: ").append(this.toIndentedString(this.afterCursor)).append("\n");
        sb.append("    beforeCursor: ").append(this.toIndentedString(this.beforeCursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

