/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Campaign;
import com.zendesk.sunshine_conversations_client.model.Client;
import com.zendesk.sunshine_conversations_client.model.Device;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "integrationId", "originalMessageId", "originalMessageTimestamp", "client", "device", "campaign"})
public class SourceWithCampaignWebhook {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private String integrationId;
    public static final String JSON_PROPERTY_ORIGINAL_MESSAGE_ID = "originalMessageId";
    private JsonNullable<String> originalMessageId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ORIGINAL_MESSAGE_TIMESTAMP = "originalMessageTimestamp";
    private JsonNullable<String> originalMessageTimestamp = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CLIENT = "client";
    private JsonNullable<Client> client = JsonNullable.of(null);
    public static final String JSON_PROPERTY_DEVICE = "device";
    private JsonNullable<Device> device = JsonNullable.of(null);
    public static final String JSON_PROPERTY_CAMPAIGN = "campaign";
    private JsonNullable<Campaign> campaign = JsonNullable.undefined();

    public SourceWithCampaignWebhook type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ios", value="An identifier for the channel from which a message originated. May include one of api, sdk, messenger, or any number of other channels.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SourceWithCampaignWebhook integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier indicating which integration the message was sent from. For user messages only.")
    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public SourceWithCampaignWebhook originalMessageId(String originalMessageId) {
        this.originalMessageId = JsonNullable.of((Object)originalMessageId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Message identifier assigned by the originating channel.")
    @JsonIgnore
    public String getOriginalMessageId() {
        return (String)this.originalMessageId.orElse(null);
    }

    @JsonProperty(value="originalMessageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getOriginalMessageId_JsonNullable() {
        return this.originalMessageId;
    }

    @JsonProperty(value="originalMessageId")
    public void setOriginalMessageId_JsonNullable(JsonNullable<String> originalMessageId) {
        this.originalMessageId = originalMessageId;
    }

    public void setOriginalMessageId(String originalMessageId) {
        this.originalMessageId = JsonNullable.of((Object)originalMessageId);
    }

    public SourceWithCampaignWebhook originalMessageTimestamp(String originalMessageTimestamp) {
        this.originalMessageTimestamp = JsonNullable.of((Object)originalMessageTimestamp);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A datetime string with the format YYYY-MM-DDThh:mm:ss.SSSZ representing when the third-party channel received the message.")
    @JsonIgnore
    public String getOriginalMessageTimestamp() {
        return (String)this.originalMessageTimestamp.orElse(null);
    }

    @JsonProperty(value="originalMessageTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getOriginalMessageTimestamp_JsonNullable() {
        return this.originalMessageTimestamp;
    }

    @JsonProperty(value="originalMessageTimestamp")
    public void setOriginalMessageTimestamp_JsonNullable(JsonNullable<String> originalMessageTimestamp) {
        this.originalMessageTimestamp = originalMessageTimestamp;
    }

    public void setOriginalMessageTimestamp(String originalMessageTimestamp) {
        this.originalMessageTimestamp = JsonNullable.of((Object)originalMessageTimestamp);
    }

    public SourceWithCampaignWebhook client(Client client) {
        this.client = JsonNullable.of((Object)client);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The client from which the user authored the message or activity, if applicable. This field will only be present if the `includeFullSource` option is enabled for the webhook.")
    @JsonIgnore
    public Client getClient() {
        return (Client)this.client.orElse(null);
    }

    @JsonProperty(value="client")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Client> getClient_JsonNullable() {
        return this.client;
    }

    @JsonProperty(value="client")
    public void setClient_JsonNullable(JsonNullable<Client> client) {
        this.client = client;
    }

    public void setClient(Client client) {
        this.client = JsonNullable.of((Object)client);
    }

    public SourceWithCampaignWebhook device(Device device) {
        this.device = JsonNullable.of((Object)device);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The device from which the user authored the message or activity, if applicable. This field will only be present if the `includeFullSource` option is enabled for the webhook")
    @JsonIgnore
    public Device getDevice() {
        return (Device)this.device.orElse(null);
    }

    @JsonProperty(value="device")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Device> getDevice_JsonNullable() {
        return this.device;
    }

    @JsonProperty(value="device")
    public void setDevice_JsonNullable(JsonNullable<Device> device) {
        this.device = device;
    }

    public void setDevice(Device device) {
        this.device = JsonNullable.of((Object)device);
    }

    public SourceWithCampaignWebhook campaign(Campaign campaign) {
        this.campaign = JsonNullable.of((Object)campaign);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Campaign getCampaign() {
        return (Campaign)this.campaign.orElse(null);
    }

    @JsonProperty(value="campaign")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Campaign> getCampaign_JsonNullable() {
        return this.campaign;
    }

    @JsonProperty(value="campaign")
    public void setCampaign_JsonNullable(JsonNullable<Campaign> campaign) {
        this.campaign = campaign;
    }

    public void setCampaign(Campaign campaign) {
        this.campaign = JsonNullable.of((Object)campaign);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceWithCampaignWebhook sourceWithCampaignWebhook = (SourceWithCampaignWebhook)o;
        return Objects.equals(this.type, sourceWithCampaignWebhook.type) && Objects.equals(this.integrationId, sourceWithCampaignWebhook.integrationId) && Objects.equals(this.originalMessageId, sourceWithCampaignWebhook.originalMessageId) && Objects.equals(this.originalMessageTimestamp, sourceWithCampaignWebhook.originalMessageTimestamp) && Objects.equals(this.client, sourceWithCampaignWebhook.client) && Objects.equals(this.device, sourceWithCampaignWebhook.device) && Objects.equals(this.campaign, sourceWithCampaignWebhook.campaign);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.integrationId, this.originalMessageId, this.originalMessageTimestamp, this.client, this.device, this.campaign);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceWithCampaignWebhook {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    originalMessageId: ").append(this.toIndentedString(this.originalMessageId)).append("\n");
        sb.append("    originalMessageTimestamp: ").append(this.toIndentedString(this.originalMessageTimestamp)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    campaign: ").append(this.toIndentedString(this.campaign)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

