/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The author of the message.")
@JsonPropertyOrder(value={"type", "userId", "userExternalId", "displayName", "avatarUrl"})
public class Author {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_USER_EXTERNAL_ID = "userExternalId";
    private String userExternalId;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_AVATAR_URL = "avatarUrl";
    private URI avatarUrl = null;

    public Author type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="business", required=true, value="The type of the author.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Author userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5963c0d619a30a2e00de36b8", value="The id of the user. Only supported when `type` is user.")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Author userExternalId(String userExternalId) {
        this.userExternalId = userExternalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-own-id", value="The externalId of the user. Only supported when `type` is user.")
    @JsonProperty(value="userExternalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserExternalId() {
        return this.userExternalId;
    }

    public void setUserExternalId(String userExternalId) {
        this.userExternalId = userExternalId;
    }

    public Author displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Steve", value="The display name of the message author.")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Author avatarUrl(URI avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A custom message icon url. The image must be in either JPG, PNG, or GIF format")
    @JsonProperty(value="avatarUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(URI avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Author author = (Author)o;
        return Objects.equals((Object)this.type, (Object)author.type) && Objects.equals(this.userId, author.userId) && Objects.equals(this.userExternalId, author.userExternalId) && Objects.equals(this.displayName, author.displayName) && Objects.equals(this.avatarUrl, author.avatarUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.userId, this.userExternalId, this.displayName, this.avatarUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Author {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userExternalId: ").append(this.toIndentedString(this.userExternalId)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    avatarUrl: ").append(this.toIndentedString(this.avatarUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        BUSINESS("business"),
        USER("user");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

