/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.zendesk.sunshine_conversations_client.model.Android;
import com.zendesk.sunshine_conversations_client.model.Apple;
import com.zendesk.sunshine_conversations_client.model.Custom;
import com.zendesk.sunshine_conversations_client.model.Instagram;
import com.zendesk.sunshine_conversations_client.model.Integration;
import com.zendesk.sunshine_conversations_client.model.Ios;
import com.zendesk.sunshine_conversations_client.model.Line;
import com.zendesk.sunshine_conversations_client.model.Mailgun;
import com.zendesk.sunshine_conversations_client.model.Messagebird;
import com.zendesk.sunshine_conversations_client.model.Telegram;
import com.zendesk.sunshine_conversations_client.model.Twilio;
import com.zendesk.sunshine_conversations_client.model.Twitter;
import com.zendesk.sunshine_conversations_client.model.Viber;
import com.zendesk.sunshine_conversations_client.model.Web;
import com.zendesk.sunshine_conversations_client.model.Whatsapp;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "pageAccessToken", "appId", "appSecret"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Android.class, name="android"), @JsonSubTypes.Type(value=Apple.class, name="apple"), @JsonSubTypes.Type(value=Custom.class, name="custom"), @JsonSubTypes.Type(value=Instagram.class, name="instagram"), @JsonSubTypes.Type(value=Ios.class, name="ios"), @JsonSubTypes.Type(value=Line.class, name="line"), @JsonSubTypes.Type(value=Mailgun.class, name="mailgun"), @JsonSubTypes.Type(value=Messagebird.class, name="messagebird"), @JsonSubTypes.Type(value=Messenger.class, name="messenger"), @JsonSubTypes.Type(value=Telegram.class, name="telegram"), @JsonSubTypes.Type(value=Twilio.class, name="twilio"), @JsonSubTypes.Type(value=Twitter.class, name="twitter"), @JsonSubTypes.Type(value=Viber.class, name="viber"), @JsonSubTypes.Type(value=Web.class, name="web"), @JsonSubTypes.Type(value=Whatsapp.class, name="whatsapp")})
public class Messenger
extends Integration {
    public static final String JSON_PROPERTY_TYPE = "type";
    protected String type = "messenger";
    public static final String JSON_PROPERTY_PAGE_ACCESS_TOKEN = "pageAccessToken";
    private String pageAccessToken;
    public static final String JSON_PROPERTY_APP_ID = "appId";
    private String appId;
    public static final String JSON_PROPERTY_APP_SECRET = "appSecret";
    private String appSecret;

    @Override
    public Messenger type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Facebook Messenger Setup steps: - Take note of your Facebook app ID and secret (apps can be created at developer.facebook.com); - The Facebook app must have been submitted to Facebook for app review with the \u201cmanage_pages\u201d (to retrieve Page Access Tokens for the Pages, apps that the app user administers and set a webhook) and \u201cpages_messaging\u201d (to send messages) permissions. - In order to integrate a Facebook Messenger app you must acquire a Page Access Token from your user. Once you have acquired a page access token from your user, call the Create Integration endpoint with your app secret and ID and the user\u2019s page access token. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Messenger pageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
        return this;
    }

    @ApiModelProperty(example="your_access_token", required=true, value="A Facebook Page Access Token.")
    @JsonProperty(value="pageAccessToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPageAccessToken() {
        return this.pageAccessToken;
    }

    public void setPageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
    }

    public Messenger appId(String appId) {
        this.appId = appId;
        return this;
    }

    @ApiModelProperty(example="your_facebook_app_id", required=true, value="A Facebook App ID.")
    @JsonProperty(value="appId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Messenger appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    @ApiModelProperty(example="your_facebook_app_secret", required=true, value="A Facebook App Secret.")
    @JsonProperty(value="appSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Messenger messenger = (Messenger)o;
        return Objects.equals(this.type, messenger.type) && Objects.equals(this.pageAccessToken, messenger.pageAccessToken) && Objects.equals(this.appId, messenger.appId) && Objects.equals(this.appSecret, messenger.appSecret) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.pageAccessToken, this.appId, this.appSecret, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Messenger {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    pageAccessToken: ").append(this.toIndentedString(this.pageAccessToken)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    appSecret: ").append(this.toIndentedString(this.appSecret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

