/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Action;
import com.zendesk.sunshine_conversations_client.model.Content;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "text", "actions"})
public class TextMessage
implements Content {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "text";
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private List<Action> actions = null;

    public TextMessage type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TextMessage text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Hello!", value="The text content of the message. Optional only if actions are provided.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TextMessage actions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public TextMessage addActionsItem(Action actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of message actions.")
    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMessage textMessage = (TextMessage)o;
        return Objects.equals(this.type, textMessage.type) && Objects.equals(this.text, textMessage.text) && Objects.equals(this.actions, textMessage.actions);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.text, this.actions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextMessage {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

