/*
 * Decompiled with CFR 0.152.
 */
package com.zengtengpeng.configuration;

import com.zengtengpeng.annotation.EnableCache;
import com.zengtengpeng.properties.RedissonProperties;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.redisson.api.RedissonClient;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
@EnableCaching
@EnableConfigurationProperties(value={RedissonProperties.class})
public class CacheConfiguration
implements ImportAware {
    private String[] value;
    Logger logger = LoggerFactory.getLogger(CacheConfiguration.class);
    private long ttl;
    private long maxIdleTime;
    @Resource
    private RedissonClient redissonClient;
    @Autowired
    private RedissonProperties redissonProperties;

    @Bean
    CacheManager cacheManager() {
        HashMap<String, CacheConfig> config = new HashMap<String, CacheConfig>();
        for (String s : this.value) {
            this.logger.info("\u521d\u59cb\u5316spring cache\u7a7a\u95f4{}", (Object)s);
            config.put(s, new CacheConfig(this.ttl, this.maxIdleTime));
        }
        return new RedissonSpringCacheManager(this.redissonClient, config);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableAttrMap = importMetadata.getAnnotationAttributes(EnableCache.class.getName());
        AnnotationAttributes enableAttrs = AnnotationAttributes.fromMap((Map)enableAttrMap);
        this.value = enableAttrs.getStringArray("value");
        this.maxIdleTime = (Long)enableAttrs.getNumber("maxIdleTime");
        this.ttl = (Long)enableAttrs.getNumber("ttl");
    }
}

