/*
 * Decompiled with CFR 0.152.
 */
package com.zengtengpeng.operation;

import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Resource;
import org.redisson.api.RBinaryStream;
import org.redisson.api.RListMultimap;
import org.redisson.api.RedissonClient;

public class RedissonBinary {
    @Resource
    private RedissonClient redissonClient;

    public OutputStream getOutputStream(String name) {
        RListMultimap listMultimap = this.redissonClient.getListMultimap("");
        RBinaryStream binaryStream = this.redissonClient.getBinaryStream(name);
        return binaryStream.getOutputStream();
    }

    public InputStream getInputStream(String name) {
        RBinaryStream binaryStream = this.redissonClient.getBinaryStream(name);
        return binaryStream.getInputStream();
    }

    public InputStream getValue(String name, OutputStream stream) {
        try {
            int len;
            RBinaryStream binaryStream = this.redissonClient.getBinaryStream(name);
            InputStream inputStream = binaryStream.getInputStream();
            byte[] buff = new byte[1024];
            while ((len = inputStream.read(buff)) != -1) {
                stream.write(buff, 0, len);
            }
            return binaryStream.getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RBinaryStream getBucket(String name) {
        return this.redissonClient.getBinaryStream(name);
    }

    public void setValue(String name, InputStream value) {
        try {
            int len;
            RBinaryStream binaryStream = this.redissonClient.getBinaryStream(name);
            binaryStream.delete();
            OutputStream outputStream = binaryStream.getOutputStream();
            byte[] buff = new byte[1024];
            while ((len = value.read(buff)) != -1) {
                outputStream.write(buff, 0, len);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Boolean delete(String name) {
        RBinaryStream binaryStream = this.redissonClient.getBinaryStream(name);
        return binaryStream.delete();
    }
}

