/*
 * Decompiled with CFR 0.152.
 */
package com.zengtengpeng.operation;

import com.zengtengpeng.func.DataCache;
import com.zengtengpeng.func.RealData;
import com.zengtengpeng.func.RealDataMap;
import com.zengtengpeng.func.RealDataSet;
import com.zengtengpeng.properties.RedissonProperties;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.api.RMapCache;
import org.redisson.api.RSetCache;
import org.redisson.api.RedissonClient;
import org.springframework.util.ObjectUtils;

public class RedissonCollectionCache {
    @Resource
    private RedissonClient redissonClient;
    @Resource
    private RedissonProperties redissonProperties;

    public <K, V> RMapCache<K, V> getMapCache(String name) {
        return this.redissonClient.getMapCache(name);
    }

    public <K, V> RMapCache<K, V> getMapCache(String name, RealDataMap<K, V> realDataMap) {
        return this.getMapCache(name, realDataMap, this.redissonProperties.getDataValidTime());
    }

    public <K, V> RMapCache<K, V> getMapCache(String name, RealDataMap<K, V> realDataMap, Long time) {
        RMapCache map = this.redissonClient.getMapCache(name);
        if (map == null || map.size() == 0) {
            Map<K, V> objectObjectMap = realDataMap.get();
            this.setMapCacheValues(name, objectObjectMap, time);
        }
        return this.redissonClient.getMapCache(name);
    }

    public <T> T getMapCacheValue(String name, String key) {
        RMapCache mapCache = this.getMapCache(name);
        return (T)mapCache.get((Object)key);
    }

    public <T> T getMapCacheValue(String name, String key, RealData<T> realData) {
        return this.getMapCacheValue(name, key, realData, this.redissonProperties.getDataValidTime());
    }

    public <T> T getMapCacheValue(String name, String key, RealData<T> realData, Long time) {
        RMapCache mapCache = this.getMapCache(name);
        Object o = mapCache.get((Object)key);
        if (o == null) {
            o = realData.get();
            if (ObjectUtils.isEmpty((Object)o)) {
                mapCache.remove((Object)key);
            } else {
                this.setMapCacheValue(name, key, o, time);
            }
        }
        return (T)o;
    }

    public <T> T getMapCacheValue(String name, String key, RealData<T> realData, DataCache<T> dataCache, Long time) {
        RMapCache mapCache = this.getMapCache(name);
        Object o = mapCache.get((Object)key);
        if (o == null) {
            o = realData.get();
            if (ObjectUtils.isEmpty((Object)o)) {
                mapCache.remove((Object)key);
            } else {
                Boolean cache = dataCache.isCache(o);
                if (cache.booleanValue()) {
                    this.setMapCacheValue(name, key, o, time);
                }
            }
        }
        return (T)o;
    }

    public <K, V> void setMapCacheValues(String name, Map<K, V> data, Long time) {
        RMapCache map = this.redissonClient.getMapCache(name);
        if (time == null) {
            time = this.redissonProperties.getDataValidTime();
        }
        map.putAll(data, time.longValue(), TimeUnit.MILLISECONDS);
    }

    public void setMapCacheValue(String name, String key, Object value, Long time) {
        this.setMapCacheValue(name, key, value, time, 0L);
    }

    public <T> void setMapCacheValue(String name, String key, T value, Long time, Long maxIdleTime) {
        RMapCache map = this.redissonClient.getMapCache(name);
        if (time == null) {
            time = this.redissonProperties.getDataValidTime();
        }
        map.put((Object)key, value, time.longValue(), TimeUnit.MILLISECONDS, maxIdleTime.longValue(), TimeUnit.MILLISECONDS);
    }

    public <K, V> void setMapCacheValues(String name, Map<K, V> data) {
        this.setMapCacheValues(name, data, this.redissonProperties.getDataValidTime());
    }

    public void setMapCacheValue(String name, String key, Object value) {
        this.setMapCacheValue(name, key, value, this.redissonProperties.getDataValidTime());
    }

    public <T> RSetCache<T> getSetCache(String name) {
        return this.redissonClient.getSetCache(name);
    }

    public <T> RSetCache<T> getSetCache(String name, RealDataSet<T> realDataSet, Long time) {
        RSetCache<T> set = this.getSetCache(name);
        if (set == null || set.size() == 0) {
            Set<T> objects = realDataSet.get();
            this.setSetCacheValues(name, objects, time);
        }
        return this.getSetCache(name);
    }

    public <T> RSetCache<T> getSetCache(String name, RealDataSet<T> realDataSet) {
        return this.getSetCache(name, realDataSet, this.redissonProperties.getDataValidTime());
    }

    public <T> void setSetCacheValues(String name, Set<T> data, Long time) {
        RSetCache set = this.redissonClient.getSetCache(name);
        set.addAll(data);
        Long dataValidTime = this.redissonProperties.getDataValidTime();
        if (time == null) {
            set.expire(Duration.ofMillis(dataValidTime));
        } else if (time != -1L) {
            set.expire(Duration.ofMillis(time));
        }
    }

    public void setSetCacheValue(String name, Object data, Long time) {
        RSetCache set = this.redissonClient.getSetCache(name);
        if (time == null) {
            time = this.redissonProperties.getDataValidTime();
        }
        set.add(data, time.longValue(), TimeUnit.MILLISECONDS);
    }

    public <T> void setSetCacheValues(String name, Set<T> data) {
        this.setSetCacheValues(name, data, this.redissonProperties.getDataValidTime());
    }

    public void setSetValues(String name, Object data) {
        this.setSetCacheValue(name, data, this.redissonProperties.getDataValidTime());
    }
}

