/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.RtfDocfmt;
import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfHeader;
import com.tutego.jrtf.RtfHeaderColor;
import com.tutego.jrtf.RtfHeaderFont;
import com.tutego.jrtf.RtfInfo;
import com.tutego.jrtf.RtfPara;
import com.tutego.jrtf.RtfSectionFormatAndHeaderFooter;
import com.tutego.jrtf.RtfTemplate;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rtf {
    static final Charset CHARSET1252 = Charset.forName("Windows-1252");
    private SortedMap<Integer, RtfHeaderColor> headerColors = new TreeMap<Integer, RtfHeaderColor>();
    private List<RtfHeaderFont> headerFonts = new ArrayList<RtfHeaderFont>();
    private StringBuilder info = new StringBuilder();
    private StringBuilder docfmt = new StringBuilder();
    private List<CharSequence> secfmtHdrftrs = new ArrayList<CharSequence>();
    private List<RtfPara[]> sectionParagraphs = new ArrayList<RtfPara[]>();

    private Rtf() {
    }

    public static Rtf rtf() {
        return new Rtf();
    }

    static void asRtf(Appendable out, String rawText) throws IOException {
        byte[] bytes = rawText.getBytes(CHARSET1252.name());
        assert (rawText.length() == bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            char b = (char)(bytes[i] & 0xFF);
            if (b == '\n') {
                out.append("\\par\n");
                continue;
            }
            if (b == '\t') {
                out.append("\\tab\n");
                continue;
            }
            if (b == '\\') {
                out.append("\\\\");
                continue;
            }
            if (b == '{') {
                out.append("\\{");
                continue;
            }
            if (b == '}') {
                out.append("\\}");
                continue;
            }
            if (b < '\u007f') {
                out.append(b);
                continue;
            }
            if (b < '\u00ff') {
                out.append("\\'" + Integer.toHexString(b));
                continue;
            }
            out.append("\\u").append(Integer.toString(rawText.charAt(i))).append('?');
        }
    }

    static String asRtf(String rawText) {
        if (rawText == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(rawText.length() * 2);
        try {
            Rtf.asRtf(result, rawText);
        }
        catch (IOException e) {
            throw new RtfException(e);
        }
        return result.toString();
    }

    public Rtf header(RtfHeader ... headers) {
        for (RtfHeader rtfHeader : headers) {
            if (rtfHeader instanceof RtfHeaderColor) {
                this.headerColors.put(((RtfHeaderColor)rtfHeader).colorindex, (RtfHeaderColor)rtfHeader);
                continue;
            }
            if (!(rtfHeader instanceof RtfHeaderFont)) continue;
            this.headerFonts.add((RtfHeaderFont)rtfHeader);
        }
        return this;
    }

    public Rtf info(RtfInfo ... infos) {
        for (RtfInfo rtfInfo : infos) {
            this.info.append(rtfInfo.rtf);
        }
        return this;
    }

    public Rtf documentFormatting(RtfDocfmt ... documentFormattings) {
        for (RtfDocfmt rtfDocfmt : documentFormattings) {
            this.docfmt.append(rtfDocfmt.rtf);
        }
        return this;
    }

    public Rtf section(RtfPara ... paragraphs) {
        return this.section((RtfSectionFormatAndHeaderFooter)null, paragraphs);
    }

    public Rtf section(Collection<RtfPara> paragraphs) {
        return this.section((RtfSectionFormatAndHeaderFooter)null, paragraphs.toArray(new RtfPara[paragraphs.size()]));
    }

    public Rtf section(RtfSectionFormatAndHeaderFooter secfmtHdrftr, RtfPara ... paragraphs) {
        if (paragraphs == null) {
            throw new IllegalArgumentException("There has to be atleast one paragraph in a section");
        }
        if (secfmtHdrftr != null) {
            this.secfmtHdrftrs.add(secfmtHdrftr.rtf);
        } else {
            this.secfmtHdrftrs.add(null);
        }
        this.sectionParagraphs.add(paragraphs);
        return this;
    }

    public void p(Object ... texts) {
        this.section(RtfPara.p(texts));
    }

    public void out(Appendable out) {
        if (out == null) {
            throw new IllegalArgumentException("Appendable is not allowed to be null");
        }
        try {
            this.writeRtfDocument(out);
        }
        catch (IOException e) {
            throw new RtfException(e);
        }
        finally {
            if (out instanceof Closeable) {
                try {
                    ((Closeable)((Object)out)).close();
                }
                catch (IOException e) {
                    throw new RtfException(e);
                }
            }
        }
    }

    public CharSequence out() {
        StringBuilder result = new StringBuilder(4096);
        this.out(result);
        return result;
    }

    public String toString() {
        return this.out().toString();
    }

    public static RtfTemplate template(InputStream inputStream) {
        return new RtfTemplate(inputStream);
    }

    private void writeRtfDocument(Appendable out) throws IOException {
        out.append("{");
        out.append("\\rtf1\\ansi\\deff0");
        out.append("\n{\\fonttbl");
        if (this.headerFonts.isEmpty()) {
            out.append("{\\f0 Times New Roman;}");
        } else {
            for (RtfHeaderFont font : this.headerFonts) {
                font.writeFontInfo(out);
            }
        }
        out.append('}');
        if (!this.headerColors.isEmpty()) {
            out.append("\n{\\colortbl");
            int maxColorIndex = this.headerColors.lastKey();
            for (int i = 0; i <= maxColorIndex; ++i) {
                RtfHeaderColor color = (RtfHeaderColor)this.headerColors.get(i);
                if (color == null) {
                    out.append(';');
                    continue;
                }
                color.writeColordef(out);
            }
            out.append('}');
        }
        out.append('\n');
        if (this.info.length() > 0) {
            out.append("{\\info");
            out.append(this.info);
            out.append("}\n");
        }
        if (this.docfmt.length() > 0) {
            out.append(this.docfmt);
        }
        for (int sectionCnt = 0; sectionCnt < this.sectionParagraphs.size(); ++sectionCnt) {
            RtfPara[] paragraphs = this.sectionParagraphs.get(sectionCnt);
            CharSequence secfmtHdrftr = this.secfmtHdrftrs.get(sectionCnt);
            if (secfmtHdrftr != null) {
                out.append(secfmtHdrftr);
            }
            for (RtfPara rtfPara : paragraphs) {
                rtfPara.rtf(out, true);
            }
            if (sectionCnt == this.sectionParagraphs.size() - 1) continue;
            out.append("\\sect\n");
        }
        out.append("}");
    }

    static StringBuilder frameRtfParagraphWithEndingPar(String rtfControlWord, RtfPara para) {
        try {
            StringBuilder out = new StringBuilder(1024);
            out.append("{\\");
            out.append(rtfControlWord);
            para.rtf(out, true);
            out.append('}');
            return out;
        }
        catch (IOException e) {
            throw new RtfException(e);
        }
    }
}

