/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfHeader;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtfHeaderColor
extends RtfHeader
implements Comparable<RtfHeaderColor> {
    private int r;
    private int g;
    private int b;
    int colorindex;

    RtfHeaderColor(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public RtfHeader at(int colorindex) {
        if (colorindex < 0 || colorindex > 255) {
            throw new RtfException("Color index " + colorindex + " ist out of range, has to be between 0 and 255");
        }
        this.colorindex = colorindex;
        return this;
    }

    @Override
    public int compareTo(RtfHeaderColor other) {
        return this.colorindex - other.colorindex;
    }

    void writeColordef(Appendable out) throws IOException {
        out.append("\\red").append(Integer.toString(this.r)).append("\\green").append(Integer.toString(this.g)).append("\\blue").append(Integer.toString(this.b)).append(';');
    }
}

