/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.RtfHeader;
import java.io.IOException;

public class RtfHeaderFont
extends RtfHeader {
    public static final String COURIER = "Courier";
    public static final String HELVETICA = "Arial";
    public static final String ARIAL = "Arial";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES_ROMAN = "Times New Roman";
    public static final String ZAPFDINGBATS = "Windings";
    public static final String WINDINGS = "Windings";
    private int fontnum;
    private String fontname;
    private FontFamily fontfamily = FontFamily.NIL;
    private CharSet charSet = CharSet.ANSI;
    private Pitch pitch;

    RtfHeaderFont(String fontname) {
        this.fontname = fontname;
    }

    public RtfHeaderFont family(FontFamily fontfamily) {
        if (fontfamily == null) {
            throw new IllegalArgumentException("Font family can't be null");
        }
        this.fontfamily = fontfamily;
        return this;
    }

    public RtfHeaderFont charset(CharSet charSet) {
        if (charSet == null) {
            throw new IllegalArgumentException("Char set can't be null");
        }
        this.charSet = charSet;
        return this;
    }

    public RtfHeaderFont pitch(Pitch pitch) {
        if (pitch == null) {
            throw new IllegalArgumentException("Pitch can't be null");
        }
        this.pitch = pitch;
        return this;
    }

    public RtfHeader at(int fontnum) {
        if (fontnum < 0) {
            throw new IllegalArgumentException("Font number is not allowed to be negative");
        }
        this.fontnum = fontnum;
        return this;
    }

    void writeFontInfo(Appendable out) throws IOException {
        out.append("{\\f").append(Integer.toString(this.fontnum)).append("\\f").append(this.fontfamily.toString().toLowerCase()).append(this.charSet != null ? "\\fcharset" + (Object)((Object)this.charSet) : "").append(this.pitch != null ? "\\fprq" + (Object)((Object)this.pitch) : "").append(" ").append(this.fontname).append(";}");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Pitch {
        DEFAULT{

            public String toString() {
                return "0";
            }
        }
        ,
        FIXED{

            public String toString() {
                return "1";
            }
        }
        ,
        VARIABLE{

            public String toString() {
                return "2";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharSet {
        ANSI{

            public String toString() {
                return "0";
            }
        }
        ,
        DEFAULT{

            public String toString() {
                return "1";
            }
        }
        ,
        SYMBOL{

            public String toString() {
                return "2";
            }
        }
        ,
        MAC{

            public String toString() {
                return "77";
            }
        }
        ,
        SHIFTJIS{

            public String toString() {
                return "128";
            }
        }
        ,
        HANGUL{

            public String toString() {
                return "129";
            }
        }
        ,
        JOHAB{

            public String toString() {
                return "130";
            }
        }
        ,
        GREEK{

            public String toString() {
                return "161";
            }
        }
        ,
        TURKISH{

            public String toString() {
                return "162";
            }
        }
        ,
        VIETNAMESE{

            public String toString() {
                return "163";
            }
        }
        ,
        HEBREW{

            public String toString() {
                return "177";
            }
        }
        ,
        ARABICSIMPLIFIED{

            public String toString() {
                return "178";
            }
        }
        ,
        ARABICTRADITIONAL{

            public String toString() {
                return "179";
            }
        }
        ,
        ARABICUSER{

            public String toString() {
                return "180";
            }
        }
        ,
        HEBREWUSER{

            public String toString() {
                return "181";
            }
        }
        ,
        BALTIC{

            public String toString() {
                return "186";
            }
        }
        ,
        CYRILLIC{

            public String toString() {
                return "204";
            }
        }
        ,
        THAI{

            public String toString() {
                return "222";
            }
        }
        ,
        EASTERNEUROPE{

            public String toString() {
                return "238";
            }
        }
        ,
        PC437{

            public String toString() {
                return "254";
            }
        }
        ,
        OEM{

            public String toString() {
                return "255";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontFamily {
        NIL,
        ROMAN,
        SWISS,
        MODERN,
        SCRIPT,
        DECOR,
        TECH,
        BIDI;

    }
}

