/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.Rtf;
import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfRow;
import com.tutego.jrtf.RtfText;
import com.tutego.jrtf.RtfTextPara;
import com.tutego.jrtf.RtfUnit;
import java.io.IOException;
import java.util.ArrayList;

public abstract class RtfPara {
    abstract void rtf(Appendable var1, boolean var2) throws IOException;

    public static RtfTextPara p(Object ... texts) {
        return RtfPara.p(RtfText.text(texts));
    }

    public static RtfTextPara p(final RtfText ... texts) {
        if (texts == null || texts.length == 0) {
            return new RtfTextPara(){

                void rtf(Appendable out, boolean withEndingPar) throws IOException {
                    out.append("\\par");
                }
            };
        }
        return new RtfTextPara(){

            void rtf(Appendable out, boolean withEndingPar) throws IOException {
                out.append("{");
                out.append(this.textparFormatRtf());
                for (RtfText rtfText : texts) {
                    rtfText.rtf(out);
                }
                if (withEndingPar) {
                    out.append("\\par");
                }
                out.append("}\n");
            }
        };
    }

    public static RtfTextPara pard(final RtfText ... texts) {
        if (texts == null || texts.length == 0) {
            return new RtfTextPara(){

                void rtf(Appendable out, boolean withEndingPar) throws IOException {
                    out.append("\\pard\\par");
                }
            };
        }
        return new RtfTextPara(){

            void rtf(Appendable out, boolean withEndingPar) throws IOException {
                out.append("{\\pard");
                out.append(this.textparFormatRtf());
                for (RtfText rtfText : texts) {
                    rtfText.rtf(out);
                }
                if (withEndingPar) {
                    out.append("\\par");
                }
                out.append("}\n");
            }
        };
    }

    public static RtfPara ul(String text) {
        return RtfPara.ul(Rtf.asRtf(text));
    }

    public static RtfPara ul(final RtfText text) {
        String s = "{\\pard{\\pntext\\bullet\\tab}{\\*\\pn\\pnlvlblt\\pnf1\\pnindent0{\\pntxtb\\bullet}}\\fi-200\\li200 ";
        return new RtfPara(){

            void rtf(Appendable out, boolean withEndingPar) throws IOException {
                out.append("{\\pard{\\pntext\\bullet\\tab}{\\*\\pn\\pnlvlblt\\pnf1\\pnindent0{\\pntxtb\\bullet}}\\fi-200\\li200 ");
                text.rtf(out);
                out.append('}');
            }
        };
    }

    public static RtfPara hangingUl(RtfText text, double beforeBulletWidth, RtfUnit beforeBulletUnit, double indentWidth, RtfUnit indentUnit, double afterItemSpace, RtfUnit afterItemUnit) {
        return RtfPara.hangingUl(new RtfText("\\bullet"), text, beforeBulletWidth, beforeBulletUnit, indentWidth, indentUnit, afterItemSpace, afterItemUnit);
    }

    public static RtfPara hangingUl(final RtfText bulletText, final RtfText text, double beforeBulletWidth, RtfUnit beforeBulletUnit, double indentWidth, RtfUnit indentUnit, double afterItemSpace, RtfUnit afterItemUnit) {
        int beforeTwips = beforeBulletUnit.toTwips(beforeBulletWidth);
        int indentTwips = indentUnit.toTwips(indentWidth);
        int afterItemTwips = afterItemUnit.toTwips(afterItemSpace);
        final String s = String.format("{%s\\li%d\\fi-%d", afterItemTwips != 0 ? "\\sa" + afterItemTwips : "", indentTwips, indentTwips - beforeTwips);
        return new RtfPara(){

            void rtf(Appendable out, boolean withEndingPar) throws IOException {
                out.append(s);
                out.append("{");
                bulletText.rtf(out);
                out.append("\\tab");
                out.append("}");
                text.rtf(out);
                out.append("\\par}");
            }
        };
    }

    public static RtfRow row(RtfText ... cells) {
        if (cells == null) {
            throw new RtfException("There has to be at least one cell in a row");
        }
        ArrayList<RtfTextPara> paras = new ArrayList<RtfTextPara>();
        for (RtfText cell : cells) {
            paras.add(RtfPara.p(cell));
        }
        RtfPara[] parasArray = new RtfPara[paras.size()];
        return RtfPara.row(paras.toArray(parasArray));
    }

    public static RtfRow row(Object ... cells) {
        if (cells == null) {
            throw new RtfException("There has to be at least one cell in a row");
        }
        ArrayList<RtfPara> paras = new ArrayList<RtfPara>();
        for (Object cell : cells) {
            if (cell instanceof RtfPara) {
                paras.add((RtfPara)cell);
                continue;
            }
            paras.add(RtfPara.p(cell));
        }
        RtfPara[] parasArray = new RtfPara[paras.size()];
        return RtfPara.row(paras.toArray(parasArray));
    }

    public static RtfRow row(final RtfPara ... cells) {
        if (cells == null) {
            throw new RtfException("There has to be at least one cell in a row");
        }
        return new RtfRow(){

            void rtf(Appendable out, boolean withEndingPar) throws IOException {
                out.append("{\\trowd\\trautofit1\\intbl\n");
                for (int i = 1; i <= cells.length; ++i) {
                    out.append(this.tbldef).append(cells[i - 1] instanceof RtfTextPara ? ((RtfTextPara)cells[i - 1]).cellfmt : "").append("\\cellx").append(Integer.toString(i)).append("\n");
                }
                for (RtfPara cell : cells) {
                    cell.rtf(out, false);
                    out.append("\\cell\n");
                }
                out.append("\\row}");
            }
        };
    }
}

