/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.Rtf;
import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfText;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtfTemplate {
    private StringBuilder template = new StringBuilder(8192);
    private Map<String, Object> map = new HashMap<String, Object>();
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("%%(\\S+)%%", 40);

    RtfTemplate(InputStream inputStream) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        InputStreamReader reader = new InputStreamReader(inputStream, Rtf.CHARSET1252);
        try {
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                this.template.append((char)c);
            }
        }
        catch (IOException e) {
            throw new RtfException(e);
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RtfException(e);
            }
        }
    }

    public RtfTemplate inject(Map<String, Object> map) {
        this.map.putAll(map);
        return this;
    }

    public RtfTemplate inject(String key, Object value) {
        this.map.put(key, String.valueOf(value));
        return this;
    }

    public String out() {
        if (this.map.isEmpty()) {
            return this.template.toString();
        }
        StringBuffer result = new StringBuffer(this.template.length());
        Matcher matcher = VARIABLE_PATTERN.matcher(this.template);
        while (matcher.find()) {
            Object value = this.map.get(matcher.group(1));
            if (value == null) continue;
            StringBuilder sb = new StringBuilder(128);
            try {
                RtfText.text(value).rtf(sb);
            }
            catch (IOException e) {
                throw new RtfException(e);
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(sb.toString()));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public void out(OutputStream out) {
        try {
            String out2 = this.out();
            out.write(out2.getBytes(Rtf.CHARSET1252.name()));
        }
        catch (IOException e) {
            throw new RtfException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                throw new RtfException(e);
            }
        }
    }
}

