/*
 * Decompiled with CFR 0.152.
 */
package intoxicant.analytics.corenlp;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;

public class StopwordAnnotator
implements Annotator,
CoreAnnotation<Pair<Boolean, Boolean>> {
    public static final String ANNOTATOR_CLASS = "stopword";
    public static final String STOPWORDS_LIST = "stopword-list";
    public static final String IGNORE_STOPWORD_CASE = "ignore-stopword-case";
    private static Class<? extends Pair> boolPair = Pair.makePair((Object)true, (Object)true).getClass();
    private Properties props;
    private CharArraySet stopwords;

    public StopwordAnnotator() {
        this(new Properties());
    }

    public StopwordAnnotator(String notUsed, Properties props) {
        this(props);
    }

    public StopwordAnnotator(Properties props) {
        this.props = props;
        if (this.props.containsKey(STOPWORDS_LIST)) {
            String stopwordList = props.getProperty(STOPWORDS_LIST);
            boolean ignoreCase = Boolean.parseBoolean(props.getProperty(IGNORE_STOPWORD_CASE, "false"));
            this.stopwords = StopwordAnnotator.getStopWordList(Version.LUCENE_36, stopwordList, ignoreCase);
        } else {
            this.stopwords = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
        }
    }

    public void annotate(Annotation annotation) {
        if (this.stopwords != null && this.stopwords.size() > 0 && annotation.containsKey(CoreAnnotations.TokensAnnotation.class)) {
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            for (CoreLabel token : tokens) {
                boolean isWordStopword = this.stopwords.contains((CharSequence)token.word().toLowerCase());
                boolean isLemmaStopword = this.stopwords.contains((CharSequence)token.lemma().toLowerCase());
                Pair pair = Pair.makePair((Object)isWordStopword, (Object)isLemmaStopword);
                token.set(StopwordAnnotator.class, (Object)pair);
            }
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(StopwordAnnotator.class);
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class)));
    }

    public Class<Pair<Boolean, Boolean>> getType() {
        return boolPair;
    }

    public static CharArraySet getStopWordList(Version luceneVersion, String stopwordList, boolean ignoreCase) {
        String[] terms = stopwordList.split(",");
        CharArraySet stopwordSet = new CharArraySet(luceneVersion, terms.length, ignoreCase);
        for (String term : terms) {
            stopwordSet.add(term);
        }
        return CharArraySet.unmodifiableSet((CharArraySet)stopwordSet);
    }
}

