/*
 * Decompiled with CFR 0.152.
 */
package com.zenvia.api.sdk.webhook.jersey;

import com.zenvia.api.sdk.client.AbstractClient;
import com.zenvia.api.sdk.client.ChannelType;
import com.zenvia.api.sdk.webhook.AbstractWebhookController;
import com.zenvia.api.sdk.webhook.Event;
import com.zenvia.api.sdk.webhook.MessageEventCallback;
import com.zenvia.api.sdk.webhook.MessageStatusEventCallback;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookController
extends AbstractWebhookController {
    private static final Logger LOG = LoggerFactory.getLogger(WebhookController.class);

    public WebhookController(ResourceConfig resourceConfig, MessageEventCallback messageEventHandler) {
        this(resourceConfig, messageEventHandler, null, null);
    }

    public WebhookController(ResourceConfig resourceConfig, MessageEventCallback messageEventHandler, MessageStatusEventCallback messageStatusEventHandler) {
        this(resourceConfig, messageEventHandler, messageStatusEventHandler, null, null, null, null);
    }

    public WebhookController(ResourceConfig resourceConfig, MessageEventCallback messageEventHandler, MessageStatusEventCallback messageStatusEventHandler, String path) {
        this(resourceConfig, messageEventHandler, messageStatusEventHandler, path, null, null, null);
    }

    public WebhookController(ResourceConfig resourceConfig, MessageEventCallback messageEventHandler, String path) {
        this(resourceConfig, messageEventHandler, null, path, null, null, null);
    }

    public WebhookController(ResourceConfig resourceConfig, MessageStatusEventCallback messageStatusEventHandler) {
        this(resourceConfig, null, messageStatusEventHandler, null);
    }

    public WebhookController(ResourceConfig resourceConfig, MessageStatusEventCallback messageStatusEventHandler, String path) {
        this(resourceConfig, null, messageStatusEventHandler, path);
    }

    public WebhookController(ResourceConfig resourceConfig, MessageEventCallback messageEventHandler, AbstractClient client, String url, ChannelType channel) {
        this(resourceConfig, messageEventHandler, null, null, client, url, channel);
    }

    public WebhookController(ResourceConfig resourceConfig, MessageStatusEventCallback messageStatusEventHandler, AbstractClient client, String url, ChannelType channel) {
        this(resourceConfig, null, messageStatusEventHandler, null, client, url, channel);
    }

    public WebhookController(ResourceConfig resourceConfig, MessageEventCallback messageEventHandler, MessageStatusEventCallback messageStatusEventHandler, AbstractClient client, String url, ChannelType channel) {
        this(resourceConfig, messageEventHandler, messageStatusEventHandler, null, client, url, channel);
    }

    public WebhookController(ResourceConfig resourceConfig, MessageEventCallback messageEventHandler, MessageStatusEventCallback messageStatusEventHandler, String path, AbstractClient client, String url, ChannelType channel) {
        super(messageEventHandler, messageStatusEventHandler, path, client, url, channel);
        this.create(resourceConfig, this.path);
    }

    private void create(ResourceConfig resourceConfig, String path) {
        Resource.Builder resourceBuilder = Resource.builder((String)path);
        resourceBuilder.addMethod("POST").handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext data) {
                Event event = (Event)((ContainerRequest)data).readEntity(Event.class);
                switch (event.type) {
                    case MESSAGE: {
                        if (WebhookController.this.messageEventHandler == null) break;
                        try {
                            WebhookController.this.messageEventHandler.onMessageEvent(event.ofMessage());
                        }
                        catch (Exception e) {
                            LOG.warn("Error on handling MESSAGE event", (Throwable)e);
                        }
                        break;
                    }
                    case MESSAGE_STATUS: {
                        if (WebhookController.this.messageStatusEventHandler == null) break;
                        try {
                            WebhookController.this.messageStatusEventHandler.onMessageStatusEvent(event.ofMessageStatus());
                        }
                        catch (Exception e) {
                            LOG.warn("Error on handling MESSAGE_STATUS event", (Throwable)e);
                        }
                        break;
                    }
                }
                return Response.ok().build();
            }
        });
        resourceConfig.registerResources(new Resource[]{resourceBuilder.build()});
    }
}

