/*
 * Decompiled with CFR 0.152.
 */
package IceMX;

import IceInternal.MetricsMap;
import IceMX.Metrics;
import IceMX.MetricsHelper;
import IceUtilInternal.StopWatch;
import java.util.ArrayList;
import java.util.List;

public class Observer<T extends Metrics>
extends StopWatch
implements Ice.Instrumentation.Observer {
    private List<MetricsMap.Entry> _objects;
    private long _previousDelay = 0L;

    @Override
    public void attach() {
        if (!this.isStarted()) {
            this.start();
        }
    }

    @Override
    public void detach() {
        long lifetime = this._previousDelay + this.stop();
        for (MetricsMap.Entry e : this._objects) {
            e.detach(lifetime);
        }
    }

    @Override
    public void failed(String exceptionName) {
        for (MetricsMap.Entry e : this._objects) {
            e.failed(exceptionName);
        }
    }

    public void forEach(MetricsUpdate<T> u) {
        for (MetricsMap.Entry e : this._objects) {
            e.execute(u);
        }
    }

    public void init(MetricsHelper<T> helper, List<MetricsMap.Entry> objects, Observer<T> previous) {
        this._objects = objects;
        if (previous == null) {
            return;
        }
        this._previousDelay = previous._previousDelay + previous.delay();
        for (MetricsMap.Entry p : previous._objects) {
            if (this._objects.contains(p)) continue;
            p.detach(this._previousDelay);
        }
    }

    public <S extends Metrics, ObserverImpl extends Observer<S>> ObserverImpl getObserver(String mapName, MetricsHelper<S> helper, Class<S> mcl, Class<ObserverImpl> ocl) {
        ArrayList<MetricsMap.Entry> metricsObjects = null;
        for (MetricsMap.Entry entry : this._objects) {
            MetricsMap.Entry e = entry.getMatching(mapName, helper, mcl);
            if (e == null) continue;
            if (metricsObjects == null) {
                metricsObjects = new ArrayList<MetricsMap.Entry>(this._objects.size());
            }
            metricsObjects.add(e);
        }
        if (metricsObjects == null) {
            return null;
        }
        try {
            Observer obsv = (Observer)ocl.newInstance();
            obsv.init(helper, metricsObjects, null);
            return (ObserverImpl)obsv;
        }
        catch (Exception ex) {
            assert (false);
            return null;
        }
    }

    public MetricsMap.Entry getEntry(MetricsMap<?> map) {
        for (MetricsMap.Entry e : this._objects) {
            if (e.getMap() != map) continue;
            return e;
        }
        return null;
    }

    public static interface MetricsUpdate<T> {
        public void update(T var1);
    }
}

