/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.ext.jwt.jose4j;

import com.zerodeplibs.webpush.jwt.VAPIDJWTCreationException;
import com.zerodeplibs.webpush.jwt.VAPIDJWTGenerator;
import com.zerodeplibs.webpush.jwt.VAPIDJWTParam;
import java.math.BigDecimal;
import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.time.Instant;
import java.util.Date;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

class Jose4jVAPIDJWTGenerator
implements VAPIDJWTGenerator {
    private final ECPrivateKey privateKey;

    Jose4jVAPIDJWTGenerator(ECPrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String generate(VAPIDJWTParam param) {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setHeader("typ", "JWT");
        jws.setAlgorithmHeaderValue("ES256");
        StringBuilder payloadBuilder = new StringBuilder();
        payloadBuilder.append('{');
        this.appendStringJsonProp("aud", param.getOrigin(), payloadBuilder);
        payloadBuilder.append(',');
        this.appendJsonProp("exp", String.valueOf(param.getExpiresAtInSeconds()), payloadBuilder);
        param.getSubject().ifPresent(sub -> {
            payloadBuilder.append(',');
            this.appendStringJsonProp("sub", (String)sub, payloadBuilder);
        });
        param.forEachAdditionalClaim((name, claim) -> {
            payloadBuilder.append(',');
            this.appendJsonProp((String)name, this.convValue(claim), payloadBuilder);
        });
        payloadBuilder.append('}');
        jws.setPayload(payloadBuilder.toString());
        jws.setKey((Key)this.privateKey);
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw VAPIDJWTCreationException.withDefaultMessage((Throwable)e);
        }
    }

    private void appendStringJsonProp(String name, String value, StringBuilder builder) {
        this.appendStringJsonToken(name, builder);
        builder.append(':');
        this.appendStringJsonToken(value, builder);
    }

    private void appendJsonProp(String name, String value, StringBuilder builder) {
        this.appendStringJsonToken(name, builder);
        builder.append(':');
        builder.append(value);
    }

    private void appendStringJsonToken(String value, StringBuilder builder) {
        builder.append("\"");
        builder.append(value);
        builder.append("\"");
    }

    private String convValue(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof Boolean || o instanceof Integer || o instanceof Long) {
            return o.toString();
        }
        if (o instanceof Double) {
            return BigDecimal.valueOf((Double)o).stripTrailingZeros().toPlainString();
        }
        if (o instanceof Date) {
            Date d = (Date)o;
            return String.valueOf(d.getTime() / 1000L);
        }
        if (o instanceof Instant) {
            Instant instant = (Instant)o;
            return String.valueOf(instant.toEpochMilli() / 1000L);
        }
        throw new IllegalArgumentException("The value of an additional claim must be an instance of String, Boolean, Integer, Long, Double, Date or Instant.");
    }
}

