/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush;

import com.zerodeplibs.webpush.PushSubscription;
import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import com.zerodeplibs.webpush.key.PublicKeySource;
import com.zerodeplibs.webpush.key.PublicKeySources;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public class UserAgentMessageEncryptionKeyInfo {
    private final ECPublicKey uaPublic;
    private final byte[] uncompressedUaPublic;
    private final byte[] authSecret;

    private UserAgentMessageEncryptionKeyInfo(ECPublicKey uaPublic, byte[] uncompressedUaPublic, byte[] authSecret) {
        this.uaPublic = uaPublic;
        this.uncompressedUaPublic = uncompressedUaPublic;
        this.authSecret = authSecret;
    }

    public static UserAgentMessageEncryptionKeyInfo from(PushSubscription.Keys subscriptionKeys) {
        WebPushPreConditions.checkNotNull(subscriptionKeys, "subscriptionKeys");
        return UserAgentMessageEncryptionKeyInfo.of(subscriptionKeys.getP256dh(), subscriptionKeys.getAuth());
    }

    public static UserAgentMessageEncryptionKeyInfo of(String p256dh, String auth) {
        WebPushPreConditions.checkNotNull(p256dh, "p256dh");
        WebPushPreConditions.checkNotNull(auth, "auth");
        return UserAgentMessageEncryptionKeyInfo.of(UserAgentMessageEncryptionKeyInfo.base64urlToBytes(p256dh), UserAgentMessageEncryptionKeyInfo.base64urlToBytes(auth));
    }

    public static UserAgentMessageEncryptionKeyInfo of(byte[] p256dh, byte[] auth) {
        WebPushPreConditions.checkNotNull(p256dh, "p256dh");
        WebPushPreConditions.checkNotNull(auth, "auth");
        PublicKeySource publicKeySource = PublicKeySources.ofUncompressedBytes(p256dh);
        return new UserAgentMessageEncryptionKeyInfo(publicKeySource.extract(), Arrays.copyOf(p256dh, p256dh.length), Arrays.copyOf(auth, auth.length));
    }

    private static byte[] base64urlToBytes(String text) {
        return Base64.getUrlDecoder().decode(text);
    }

    ECPublicKey getPublicKey() {
        return this.uaPublic;
    }

    byte[] getUncompressedUaPublic() {
        return Arrays.copyOf(this.uncompressedUaPublic, this.uncompressedUaPublic.length);
    }

    byte[] getAuthSecret() {
        return Arrays.copyOf(this.authSecret, this.authSecret.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserAgentMessageEncryptionKeyInfo)) {
            return false;
        }
        UserAgentMessageEncryptionKeyInfo that = (UserAgentMessageEncryptionKeyInfo)o;
        return this.uaPublic.equals(that.uaPublic) && Arrays.equals(this.getUncompressedUaPublic(), that.getUncompressedUaPublic()) && Arrays.equals(this.getAuthSecret(), that.getAuthSecret());
    }

    public int hashCode() {
        int result = Objects.hash(this.uaPublic);
        result = 31 * result + Arrays.hashCode(this.getUncompressedUaPublic());
        result = 31 * result + Arrays.hashCode(this.getAuthSecret());
        return result;
    }

    public String toString() {
        return "UserAgentMessageEncryptionKeyInfo{p256dh='" + this.encodeBase64(this.uncompressedUaPublic) + "', auth='" + this.encodeBase64(this.authSecret) + "'}";
    }

    private String encodeBase64(byte[] bytes) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }
}

