/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush;

import com.zerodeplibs.webpush.StandardVAPIDKeyPair;
import com.zerodeplibs.webpush.VAPIDKeyPair;
import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import com.zerodeplibs.webpush.jwt.DefaultVAPIDJWTGeneratorFactory;
import com.zerodeplibs.webpush.jwt.VAPIDJWTGenerator;
import com.zerodeplibs.webpush.jwt.VAPIDJWTGeneratorFactory;
import com.zerodeplibs.webpush.key.PrivateKeySource;
import com.zerodeplibs.webpush.key.PublicKeySource;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.BiFunction;

public class VAPIDKeyPairs {
    private VAPIDKeyPairs() {
    }

    public static VAPIDKeyPair of(PrivateKeySource privateKeySource, PublicKeySource publicKeySource, BiFunction<ECPrivateKey, ECPublicKey, VAPIDJWTGenerator> jwtGeneratorFactory) {
        WebPushPreConditions.checkNotNull(jwtGeneratorFactory, "jwtGeneratorFactory");
        return new StandardVAPIDKeyPair(privateKeySource, publicKeySource, jwtGeneratorFactory::apply);
    }

    public static VAPIDKeyPair of(PrivateKeySource privateKeySource, PublicKeySource publicKeySource) {
        return new StandardVAPIDKeyPair(privateKeySource, publicKeySource, VAPIDKeyPairs.loadVAPIDJWTGeneratorFactory());
    }

    private static VAPIDJWTGeneratorFactory loadVAPIDJWTGeneratorFactory() {
        ServiceLoader<VAPIDJWTGeneratorFactory> loader = ServiceLoader.load(VAPIDJWTGeneratorFactory.class, VAPIDJWTGeneratorFactory.class.getClassLoader());
        Iterator<VAPIDJWTGeneratorFactory> factoryIterator = loader.iterator();
        if (!factoryIterator.hasNext()) {
            return new DefaultVAPIDJWTGeneratorFactory();
        }
        return factoryIterator.next();
    }
}

