/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.httpclient;

import com.zerodeplibs.webpush.header.TTL;
import com.zerodeplibs.webpush.header.Topic;
import com.zerodeplibs.webpush.header.Urgency;
import com.zerodeplibs.webpush.httpclient.PreparerBuilder;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkHttpClientRequestPreparer {
    private final PreparerBuilder.RequestPreparationInfo requestPreparationInfo;

    OkHttpClientRequestPreparer(PreparerBuilder.RequestPreparationInfo requestPreparationInfo) {
        this.requestPreparationInfo = requestPreparationInfo;
    }

    public static PreparerBuilder<OkHttpClientRequestPreparer> getBuilder() {
        return new OkHttpRequestPreparerBuilder();
    }

    public Request.Builder toRequestBuilder() {
        Request.Builder builder = new Request.Builder().url(this.requestPreparationInfo.getEndpointUrl()).addHeader("Authorization", this.requestPreparationInfo.getVapidHeader()).addHeader(TTL.HEADER_NAME, this.requestPreparationInfo.getTtlString()).addHeader(Urgency.HEADER_NAME, this.requestPreparationInfo.getUrgency());
        this.requestPreparationInfo.getEncryptedPushMessage().ifPresent(encryptedPushMessage -> builder.addHeader("Content-Type", encryptedPushMessage.mediaType()).addHeader("Content-Encoding", encryptedPushMessage.contentEncoding()).post(RequestBody.create((byte[])encryptedPushMessage.toBytes())));
        if (!this.requestPreparationInfo.getEncryptedPushMessage().isPresent()) {
            builder.post(RequestBody.create((byte[])new byte[0]));
        }
        this.requestPreparationInfo.getTopic().ifPresent(topic -> builder.addHeader(Topic.HEADER_NAME, topic));
        return builder;
    }

    public Request toRequest() {
        return this.toRequestBuilder().build();
    }

    private static class OkHttpRequestPreparerBuilder
    extends PreparerBuilder<OkHttpClientRequestPreparer> {
        private OkHttpRequestPreparerBuilder() {
        }

        @Override
        protected OkHttpClientRequestPreparer buildInternal(PreparerBuilder.RequestPreparationInfo requestPreparationInfo) {
            return new OkHttpClientRequestPreparer(requestPreparationInfo);
        }
    }
}

