/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.httpclient;

import com.zerodeplibs.webpush.header.TTL;
import com.zerodeplibs.webpush.header.Topic;
import com.zerodeplibs.webpush.header.Urgency;
import com.zerodeplibs.webpush.httpclient.PreparerBuilder;
import java.net.URI;
import java.net.http.HttpRequest;

public class StandardHttpClientRequestPreparer {
    private final PreparerBuilder.RequestPreparationInfo requestPreparationInfo;

    StandardHttpClientRequestPreparer(PreparerBuilder.RequestPreparationInfo requestPreparationInfo) {
        this.requestPreparationInfo = requestPreparationInfo;
    }

    public static PreparerBuilder<StandardHttpClientRequestPreparer> getBuilder() {
        return new StandardHttpRequestPreparerBuilder();
    }

    public HttpRequest.Builder toRequestBuilder() {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(this.requestPreparationInfo.getEndpointUrl())).header("Authorization", this.requestPreparationInfo.getVapidHeader()).header(TTL.HEADER_NAME, this.requestPreparationInfo.getTtlString()).header(Urgency.HEADER_NAME, this.requestPreparationInfo.getUrgency());
        this.requestPreparationInfo.getEncryptedPushMessage().ifPresent(encryptedPushMessage -> builder.header("Content-Type", encryptedPushMessage.mediaType()).header("Content-Encoding", encryptedPushMessage.contentEncoding()).POST(HttpRequest.BodyPublishers.ofByteArray(encryptedPushMessage.toBytes())));
        if (!this.requestPreparationInfo.getEncryptedPushMessage().isPresent()) {
            builder.POST(HttpRequest.BodyPublishers.noBody());
        }
        this.requestPreparationInfo.getTopic().ifPresent(topic -> builder.header(Topic.HEADER_NAME, (String)topic));
        return builder;
    }

    public HttpRequest toRequest() {
        return this.toRequestBuilder().build();
    }

    private static class StandardHttpRequestPreparerBuilder
    extends PreparerBuilder<StandardHttpClientRequestPreparer> {
        private StandardHttpRequestPreparerBuilder() {
        }

        @Override
        protected StandardHttpClientRequestPreparer buildInternal(PreparerBuilder.RequestPreparationInfo requestPreparationInfo) {
            return new StandardHttpClientRequestPreparer(requestPreparationInfo);
        }
    }
}

