/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.jwt;

import com.zerodeplibs.webpush.jwt.JwtUtil;
import com.zerodeplibs.webpush.jwt.VAPIDJWTGenerator;
import com.zerodeplibs.webpush.jwt.VAPIDJWTParam;
import java.math.BigDecimal;
import java.security.interfaces.ECPrivateKey;
import java.time.Instant;
import java.util.Date;

class DefaultVAPIDJWTGenerator
implements VAPIDJWTGenerator {
    private final ECPrivateKey privateKey;

    DefaultVAPIDJWTGenerator(ECPrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public String generate(VAPIDJWTParam param) {
        StringBuilder payloadBuilder = new StringBuilder();
        payloadBuilder.append('{');
        this.appendStringJsonProp("aud", param.getOrigin(), payloadBuilder);
        payloadBuilder.append(',');
        this.appendJsonProp("exp", String.valueOf(param.getExpiresAtInSeconds()), payloadBuilder);
        param.getSubject().ifPresent(sub -> {
            payloadBuilder.append(',');
            this.appendStringJsonProp("sub", (String)sub, payloadBuilder);
        });
        param.forEachAdditionalClaim((name, claim) -> {
            payloadBuilder.append(',');
            this.appendJsonProp((String)name, this.convValue(claim), payloadBuilder);
        });
        payloadBuilder.append('}');
        String header = "{\"typ\":\"JWT\",\"alg\":\"ES256\"}";
        String payload = payloadBuilder.toString();
        return JwtUtil.withSign(header, payload, this.privateKey);
    }

    private void appendStringJsonProp(String name, String value, StringBuilder builder) {
        this.appendStringJsonToken(name, builder);
        builder.append(':');
        this.appendStringJsonToken(value, builder);
    }

    private void appendJsonProp(String name, String value, StringBuilder builder) {
        this.appendStringJsonToken(name, builder);
        builder.append(':');
        builder.append(value);
    }

    private void appendStringJsonToken(String value, StringBuilder builder) {
        builder.append("\"");
        builder.append(value);
        builder.append("\"");
    }

    private String convValue(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof Boolean || o instanceof Integer || o instanceof Long) {
            return o.toString();
        }
        if (o instanceof Double) {
            return BigDecimal.valueOf((Double)o).stripTrailingZeros().toPlainString();
        }
        if (o instanceof Date) {
            Date d = (Date)o;
            return String.valueOf(d.getTime() / 1000L);
        }
        if (o instanceof Instant) {
            Instant instant = (Instant)o;
            return String.valueOf(instant.toEpochMilli() / 1000L);
        }
        throw new IllegalArgumentException("The value of an additional claim must be an instance of String, Boolean, Integer, Long, Double, Date or Instant.");
    }
}

