/*
 * Decompiled with CFR 0.152.
 */
package com.zeugmasolutions.localehelper;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.app.LocaleHelperAppCompatDelegate;
import com.zeugmasolutions.localehelper.LocaleHelper;
import com.zeugmasolutions.localehelper.LocaleHelperActivityDelegate;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/zeugmasolutions/localehelper/LocaleHelperActivityDelegateImpl;", "Lcom/zeugmasolutions/localehelper/LocaleHelperActivityDelegate;", "()V", "appCompatDelegate", "Landroidx/appcompat/app/AppCompatDelegate;", "locale", "Ljava/util/Locale;", "attachBaseContext", "Landroid/content/Context;", "newBase", "getAppCompatDelegate", "delegate", "getApplicationContext", "applicationContext", "onCreate", "", "activity", "Landroid/app/Activity;", "onPaused", "onResumed", "setLocale", "newLocale", "localehelper_release"})
public final class LocaleHelperActivityDelegateImpl
implements LocaleHelperActivityDelegate {
    @NotNull
    private Locale locale;
    @Nullable
    private AppCompatDelegate appCompatDelegate;

    public LocaleHelperActivityDelegateImpl() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        this.locale = locale;
    }

    @Override
    @NotNull
    public AppCompatDelegate getAppCompatDelegate(@NotNull AppCompatDelegate delegate) {
        AppCompatDelegate appCompatDelegate;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        AppCompatDelegate appCompatDelegate2 = this.appCompatDelegate;
        if (appCompatDelegate2 == null) {
            LocaleHelperAppCompatDelegate localeHelperAppCompatDelegate;
            LocaleHelperAppCompatDelegate $this$getAppCompatDelegate_u24lambda_u2d0 = localeHelperAppCompatDelegate = new LocaleHelperAppCompatDelegate(delegate);
            boolean bl = false;
            this.appCompatDelegate = $this$getAppCompatDelegate_u24lambda_u2d0;
            appCompatDelegate = localeHelperAppCompatDelegate;
        } else {
            appCompatDelegate = appCompatDelegate2;
        }
        return appCompatDelegate;
    }

    @Override
    public void onCreate(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 17) {
            View view = activity.getWindow().getDecorView();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            view.setLayoutDirection(LocaleHelper.INSTANCE.isRTL(locale) ? 1 : 0);
        }
    }

    @Override
    public void setLocale(@NotNull Activity activity, @NotNull Locale newLocale) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)newLocale, (String)"newLocale");
        LocaleHelper.INSTANCE.setLocale((Context)activity, newLocale);
        this.locale = newLocale;
        activity.recreate();
    }

    @Override
    @NotNull
    public Context attachBaseContext(@NotNull Context newBase) {
        Intrinsics.checkNotNullParameter((Object)newBase, (String)"newBase");
        return LocaleHelper.INSTANCE.onAttach(newBase);
    }

    @Override
    @NotNull
    public Context getApplicationContext(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return applicationContext;
    }

    @Override
    public void onPaused() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        this.locale = locale;
    }

    @Override
    public void onResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Intrinsics.areEqual((Object)this.locale, (Object)Locale.getDefault())) {
            return;
        }
        activity.recreate();
    }
}

