/*
 * Decompiled with CFR 0.152.
 */
package com.zeugmasolutions.localehelper;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00052\u0006\u0010\t\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\n"}, d2={"currentLocale", "Ljava/util/Locale;", "Landroid/content/Context;", "getCurrentLocale", "(Landroid/content/Context;)Ljava/util/Locale;", "Landroid/content/res/Configuration;", "(Landroid/content/res/Configuration;)Ljava/util/Locale;", "setCurrentLocale", "", "locale", "localehelper_release"})
public final class LocaleHelperExtensionsKt {
    @NotNull
    public static final Locale getCurrentLocale(@NotNull Context $this$currentLocale) {
        Intrinsics.checkNotNullParameter((Object)$this$currentLocale, (String)"<this>");
        Configuration configuration = $this$currentLocale.getResources().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"resources.configuration");
        return LocaleHelperExtensionsKt.getCurrentLocale(configuration);
    }

    @NotNull
    public static final Locale getCurrentLocale(@NotNull Configuration $this$currentLocale) {
        Locale locale;
        Intrinsics.checkNotNullParameter((Object)$this$currentLocale, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 24) {
            Locale locale2 = $this$currentLocale.getLocales().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"{\n        locales.get(0)\n    }");
            locale = locale2;
        } else {
            Locale locale3 = $this$currentLocale.locale;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"{\n        @Suppress(\"DEP\u2026ON\")\n        locale\n    }");
            locale = locale3;
        }
        return locale;
    }

    public static final void setCurrentLocale(@NotNull Configuration $this$setCurrentLocale, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$setCurrentLocale, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (Build.VERSION.SDK_INT >= 17) {
            $this$setCurrentLocale.setLocale(locale);
        } else {
            $this$setCurrentLocale.locale = locale;
        }
    }
}

