/*
 * Decompiled with CFR 0.152.
 */
package com.zhenzi.sms;

import com.zhenzi.sms.JsonUtil;
import com.zhenzi.sms.StreamUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ZhenziSmsClient {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private String apiUrl = "";
    private static final int connectTimeout = 20000;
    private static final int readTimeout = 20000;
    private String appId;
    private String appSecret;

    public ZhenziSmsClient(String apiUrl, String appId, String appSecret) {
        this.apiUrl = apiUrl;
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public String send(Map<String, Object> params) throws Exception {
        params.put("appId", this.appId);
        params.put("appSecret", this.appSecret);
        String result = this.doPost(this.apiUrl + "/sms/v2/send.do", params, DEFAULT_CHARSET, 20000, 20000);
        return result;
    }

    public String balance() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", this.appId);
        params.put("appSecret", this.appSecret);
        String result = this.doPost(this.apiUrl + "/account/balance.do", params, DEFAULT_CHARSET, 20000, 20000);
        return result;
    }

    public String findSmsByMessageId(String messageId) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", this.appId);
        params.put("appSecret", this.appSecret);
        params.put("messageId", messageId);
        String result = this.doPost(this.apiUrl + "/smslog/findSmsByMessageId.do", params, DEFAULT_CHARSET, 20000, 20000);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doPost(String url, Map<String, Object> params, String charset, int connectTimeout, int readTimeout) throws Exception {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = this.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = this.getConnection(new URL(url), "POST", ctype, null);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = StreamUtil.read(conn.getInputStream(), DEFAULT_CHARSET);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public String buildQuery(Map<String, Object> params, String charset) throws Exception {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, Object>> entries = params.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            Object obj = entry.getValue();
            String value = "";
            if (obj != null) {
                value = obj.getClass().isArray() ? JsonUtil.toJSONString((String[])obj) : obj.toString();
            }
            query.append(URLEncoder.encode(key, charset) + "=" + URLEncoder.encode(value, charset) + "&");
        }
        if (query.length() > 0) {
            query.deleteCharAt(query.length() - 1);
        }
        return query.toString();
    }

    private HttpURLConnection getConnection(final URL url, String method, String ctype, Map<String, String> headerMap) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        String protocol = url.getProtocol();
        if (protocol.toLowerCase().equals("https")) {
            SmsX509TrustManager xtm = new SmsX509TrustManager();
            SSLContext sslContext = null;
            sslContext = SSLContext.getInstance("TLS");
            TrustManager[] xtmArray = new X509TrustManager[]{xtm};
            sslContext.init(null, xtmArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSession) {
                    return !(hostname = ZhenziSmsClient.this.trim(hostname)).trim().equals("") && url.getHost().equals(hostname);
                }
            });
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Host", url.getHost());
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html");
        conn.setRequestProperty("Content-Type", ctype);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    private String trim(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static class SmsX509TrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

