/*
 * Decompiled with CFR 0.152.
 */
package com.zoloz.api.sdk.client;

import com.alibaba.fastjson.parser.ParserConfig;
import com.zoloz.api.sdk.util.AESUtil;
import com.zoloz.api.sdk.util.GenSignUtil;
import com.zoloz.api.sdk.util.OpenApiData;
import com.zoloz.api.sdk.util.RSAUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiClient {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiClient.class);
    private String hostUrl;
    private String clientId;
    private String merchantPrivateKey;
    private String openApiPublicKey;
    private boolean signed;
    private boolean encrypted;
    private boolean isLoadTest;

    public OpenApiClient() {
        ParserConfig parserConfig = ParserConfig.getGlobalInstance();
        parserConfig.setSafeMode(true);
        this.signed = true;
        this.encrypted = true;
    }

    public String callOpenApi(String apiName, String request) {
        String encryptKey = null;
        byte[] key = null;
        try {
            if (this.encrypted) {
                key = AESUtil.generateKey(256);
                request = AESUtil.encrypt(key, request);
                encryptKey = RSAUtil.encrypt(this.openApiPublicKey, key);
            }
        }
        catch (Exception e) {
            logger.error("encrypt key fail.", (Throwable)e);
        }
        String resultContent = null;
        try {
            Map<String, String> encrypt;
            String reqTime = ZonedDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ"));
            String signature = null;
            if (this.signed) {
                signature = this.sign(this.merchantPrivateKey, apiName, this.clientId, reqTime, request);
            }
            String url = this.hostUrl + "/api/" + apiName.replaceAll("\\.", "/");
            if (logger.isInfoEnabled()) {
                logger.info("API URL = " + url);
            }
            OpenApiData data = this.post(url, encryptKey, this.clientId, reqTime, signature, request);
            for (String k : data.getHeader().keySet()) {
                if (!logger.isInfoEnabled()) continue;
                if (k == null) {
                    logger.info(data.getHeader().get(k).get(0));
                    continue;
                }
                logger.info(k + "=" + data.getHeader().get(k).get(0));
            }
            if (data.getHeader().get("Signature") != null) {
                Map<String, String> responseSign = this.splitEncryptOrSignature(data.getHeader().get("Signature").get(0));
                String toSignContent = this.buildResponseSignatureContent(apiName, this.clientId, data.getHeader().get("Response-Time").get(0), data.getContent());
                boolean checkSignResult = GenSignUtil.verify(this.openApiPublicKey, toSignContent, URLDecoder.decode(responseSign.get("signature"), "UTF-8"));
                if (logger.isInfoEnabled()) {
                    logger.info("check response signature " + checkSignResult);
                }
            }
            resultContent = data.getContent();
            if (this.encrypted && data.getHeader().get("Encrypt") != null && (encrypt = this.splitEncryptOrSignature(data.getHeader().get("Encrypt").get(0))) != null && encrypt.get("symmetricKey") != null) {
                byte[] decryptedAESKey = RSAUtil.decrypt(this.merchantPrivateKey, URLDecoder.decode(encrypt.get("symmetricKey"), StandardCharsets.UTF_8.name()));
                resultContent = AESUtil.decrypt(decryptedAESKey, resultContent);
            }
        }
        catch (Exception e) {
            logger.error("failed to get response.", (Throwable)e);
        }
        return resultContent;
    }

    private String sign(String merchantPrivateKey, String api, String clientId, String reqTime, String request) throws Exception {
        StringBuffer sb = new StringBuffer(request.length() + 256);
        sb.append("POST ").append("/api/").append(api.replaceAll("\\.", "/")).append("\n");
        sb.append(clientId).append(".").append(reqTime).append(".").append(request);
        String str = sb.toString();
        return GenSignUtil.sign(merchantPrivateKey, str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenApiData post(String baseUrl, String encryptKey, String clientId, String reqTime, String signature, String request) {
        OpenApiData data = new OpenApiData();
        OutputStreamWriter out = null;
        BufferedReader in = null;
        StringBuffer result = new StringBuffer(20480);
        try {
            String line;
            URL realUrl = new URL(baseUrl);
            URLConnection conn = realUrl.openConnection();
            if (encryptKey != null) {
                conn.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
            } else {
                conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            }
            conn.setRequestProperty("Client-Id", clientId);
            conn.setRequestProperty("Request-Time", reqTime);
            if (this.isLoadTest) {
                conn.setRequestProperty("loadTestMode", "true");
            }
            if (signature != null) {
                conn.setRequestProperty("Signature", "algorithm=RSA256, signature=" + URLEncoder.encode(signature, StandardCharsets.UTF_8.name()));
            }
            if (encryptKey != null) {
                conn.setRequestProperty("Encrypt", "algorithm=RSA_AES, symmetricKey=" + URLEncoder.encode(encryptKey, StandardCharsets.UTF_8.name()));
            }
            if (logger.isInfoEnabled()) {
                for (String key : conn.getRequestProperties().keySet()) {
                    logger.info(key + "=" + conn.getRequestProperties().get(key).get(0));
                }
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8.name());
            out.write(request);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8.name()));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            data.setContent(result.toString());
            data.setHeader(conn.getHeaderFields());
        }
        catch (Exception e) {
            logger.error("failed to do request:{}.", (Object)request, (Object)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.error("close io fail.", (Throwable)ex);
            }
        }
        return data;
    }

    private Map<String, String> splitEncryptOrSignature(String value) {
        if (value == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] pairs = value.split(",");
        if (pairs == null) {
            return map;
        }
        for (String pair : pairs) {
            String[] kv;
            if (pair == null || (kv = pair.trim().split("=")) == null || kv.length != 2 || kv[0] == null) continue;
            map.put(kv[0].trim(), kv[1].trim());
        }
        return map;
    }

    private String buildResponseSignatureContent(String apiName, String clientId, String responseTime, String response) {
        StringBuffer sb = new StringBuffer(response.length() + 256);
        sb.append("POST ").append("/api").append("/").append(apiName.replaceAll("\\.", "/")).append("\n");
        sb.append(clientId).append(".").append(responseTime).append(".").append(response);
        return sb.toString();
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getMerchantPrivateKey() {
        return this.merchantPrivateKey;
    }

    public String getOpenApiPublicKey() {
        return this.openApiPublicKey;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isLoadTest() {
        return this.isLoadTest;
    }

    public void setHostUrl(String hostUrl) {
        this.hostUrl = hostUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setMerchantPrivateKey(String merchantPrivateKey) {
        this.merchantPrivateKey = merchantPrivateKey;
    }

    public void setOpenApiPublicKey(String openApiPublicKey) {
        this.openApiPublicKey = openApiPublicKey;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public void setLoadTest(boolean isLoadTest) {
        this.isLoadTest = isLoadTest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiClient)) {
            return false;
        }
        OpenApiClient other = (OpenApiClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hostUrl = this.getHostUrl();
        String other$hostUrl = other.getHostUrl();
        if (this$hostUrl == null ? other$hostUrl != null : !this$hostUrl.equals(other$hostUrl)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$merchantPrivateKey = this.getMerchantPrivateKey();
        String other$merchantPrivateKey = other.getMerchantPrivateKey();
        if (this$merchantPrivateKey == null ? other$merchantPrivateKey != null : !this$merchantPrivateKey.equals(other$merchantPrivateKey)) {
            return false;
        }
        String this$openApiPublicKey = this.getOpenApiPublicKey();
        String other$openApiPublicKey = other.getOpenApiPublicKey();
        if (this$openApiPublicKey == null ? other$openApiPublicKey != null : !this$openApiPublicKey.equals(other$openApiPublicKey)) {
            return false;
        }
        if (this.isSigned() != other.isSigned()) {
            return false;
        }
        if (this.isEncrypted() != other.isEncrypted()) {
            return false;
        }
        return this.isLoadTest() == other.isLoadTest();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hostUrl = this.getHostUrl();
        result = result * 59 + ($hostUrl == null ? 43 : $hostUrl.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $merchantPrivateKey = this.getMerchantPrivateKey();
        result = result * 59 + ($merchantPrivateKey == null ? 43 : $merchantPrivateKey.hashCode());
        String $openApiPublicKey = this.getOpenApiPublicKey();
        result = result * 59 + ($openApiPublicKey == null ? 43 : $openApiPublicKey.hashCode());
        result = result * 59 + (this.isSigned() ? 79 : 97);
        result = result * 59 + (this.isEncrypted() ? 79 : 97);
        result = result * 59 + (this.isLoadTest() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "OpenApiClient(hostUrl=" + this.getHostUrl() + ", clientId=" + this.getClientId() + ", merchantPrivateKey=" + this.getMerchantPrivateKey() + ", openApiPublicKey=" + this.getOpenApiPublicKey() + ", signed=" + this.isSigned() + ", encrypted=" + this.isEncrypted() + ", isLoadTest=" + this.isLoadTest() + ")";
    }
}

