/*
 * Decompiled with CFR 0.152.
 */
package com.zoominfo.api.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AuthClient {
    private static final String ENTERPRISE_API_AUDIENCE = "enterprise_api";
    private static final String USERNAME_CLAIM = "username";
    private static final String CLIENT_ID_CLAIM = "client_id";
    private static final String ISSUER = "api-client@zoominfo.com";
    private static final String AUTHENTICATE_URL = "https://api.zoominfo.com/authenticate";
    private static final int EXPIRY_TIME_SECONDS = 300;
    private boolean usernameAndPassword;
    private String username;
    private String password;
    private String clientId;
    private String privateKey;
    private final RestTemplate restTemplate = new RestTemplate();

    private AuthClient() {
    }

    public AuthClient(String username, String password) {
        this();
        this.usernameAndPassword = true;
        this.username = username;
        this.password = password;
    }

    public AuthClient(String username, String clientId, String privateKey) {
        this();
        this.usernameAndPassword = false;
        this.username = username;
        this.clientId = clientId;
        this.privateKey = privateKey;
    }

    public String getAccessToken() {
        if (this.usernameAndPassword) {
            return this.usernamePasswordAuthentication();
        }
        return this.pkiAuthentication();
    }

    private String pkiAuthentication() {
        String clientJwt = this.getClientJwt();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Authorization", "Bearer " + clientJwt);
        httpHeaders.add("Accept", "application/json");
        httpHeaders.add("user-agent", "");
        HttpEntity request = new HttpEntity(null, (MultiValueMap)httpHeaders);
        return this.postAndGetJwt((HttpEntity<Map<String, Object>>)request);
    }

    private String usernamePasswordAuthentication() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Accept", "application/json");
        httpHeaders.add("user-agent", "");
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put(USERNAME_CLAIM, this.username);
        requestBody.put("password", this.password);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)httpHeaders);
        return this.postAndGetJwt((HttpEntity<Map<String, Object>>)request);
    }

    private String postAndGetJwt(HttpEntity<Map<String, Object>> request) {
        ResponseEntity responseEntity = this.restTemplate.postForEntity(AUTHENTICATE_URL, request, Map.class, new Object[0]);
        if (responseEntity.getBody() == null) {
            throw new RuntimeException("Could not authenticate, empty response body");
        }
        return String.valueOf(((Map)responseEntity.getBody()).get("jwt"));
    }

    private String getClientJwt() {
        String clientJWT = "";
        try {
            clientJWT = this.generateClientToken();
            return clientJWT;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private String generateClientToken() throws NoSuchAlgorithmException, InvalidKeySpecException {
        Calendar cal = Calendar.getInstance();
        cal.add(12, -2);
        Date issuedAtDate = cal.getTime();
        Date expiryDate = Date.from(issuedAtDate.toInstant().plusSeconds(300L));
        return JWT.create().withAudience(new String[]{ENTERPRISE_API_AUDIENCE}).withIssuer(ISSUER).withClaim(USERNAME_CLAIM, this.username).withClaim(CLIENT_ID_CLAIM, this.clientId).withIssuedAt(issuedAtDate).withExpiresAt(expiryDate).sign(this.generateSigningAlgorithm(this.privateKey));
    }

    private Algorithm generateSigningAlgorithm(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String cleanedPrivateKey = privateKey.replaceAll("-----END PRIVATE KEY-----", "").replaceAll("-----BEGIN PRIVATE KEY-----", "").replaceAll("\n", "").trim();
        byte[] privateKeyBytes = Base64.getDecoder().decode(cleanedPrivateKey);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(privateKeySpec);
        AuthClientRSAKeyProvider keyProvider = new AuthClientRSAKeyProvider(rsaPrivateKey);
        return Algorithm.RSA256((RSAKeyProvider)keyProvider);
    }

    private static class AuthClientRSAKeyProvider
    implements RSAKeyProvider {
        private final RSAPrivateKey privateKey;

        public AuthClientRSAKeyProvider(RSAPrivateKey privateKey) {
            this.privateKey = privateKey;
        }

        public RSAPublicKey getPublicKeyById(String keyId) {
            return null;
        }

        public RSAPrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public String getPrivateKeyId() {
            return null;
        }
    }
}

