/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum BillingPeriod {
    MONTH("Month"),
    QUARTER("Quarter"),
    SEMI_ANNUAL("Semi_Annual"),
    ANNUAL("Annual"),
    EIGHTEEN_MONTHS("Eighteen_Months"),
    TWO_YEARS("Two_Years"),
    THREE_YEARS("Three_Years"),
    FIVE_YEARS("Five_Years"),
    SPECIFIC_MONTHS("Specific_Months"),
    SUBSCRIPTION_TERM("Subscription_Term"),
    WEEK("Week"),
    SPECIFIC_WEEKS("Specific_Weeks");

    private String value;

    private BillingPeriod(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BillingPeriod fromValue(String value) {
        for (BillingPeriod b : BillingPeriod.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        BillingPeriod.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<BillingPeriod> {
        public void write(JsonWriter jsonWriter, BillingPeriod enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public BillingPeriod read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return BillingPeriod.fromValue(value);
        }
    }
}

