/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum CreditCardCardType {
    VISA("Visa"),
    MASTERCARD("MasterCard"),
    AMERICANEXPRESS("AmericanExpress"),
    DISCOVER("Discover"),
    JCB("JCB"),
    DINERS("Diners"),
    CUP("CUP"),
    MAESTRO("Maestro"),
    ELECTRON("Electron"),
    APPLEVISA("AppleVisa"),
    APPLEMASTERCARD("AppleMasterCard"),
    APPLEAMERICANEXPRESS("AppleAmericanExpress"),
    APPLEDISCOVER("AppleDiscover"),
    APPLEJCB("AppleJCB"),
    ELO("Elo"),
    HIPERCARD("Hipercard"),
    NARANJA("Naranja"),
    NATIVA("Nativa"),
    TARJETASHOPPING("TarjetaShopping"),
    CENCOSUD("Cencosud"),
    ARGENCARD("Argencard"),
    CABAL("Cabal");

    private String value;

    private CreditCardCardType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CreditCardCardType fromValue(String value) {
        for (CreditCardCardType b : CreditCardCardType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        CreditCardCardType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<CreditCardCardType> {
        public void write(JsonWriter jsonWriter, CreditCardCardType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public CreditCardCardType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return CreditCardCardType.fromValue(value);
        }
    }
}

